# Embedded file name: deluge\ui\web\common.py
import zlib
import gettext
from mako.template import Template as MakoTemplate
from deluge import common
_ = lambda x: gettext.gettext(x).decode('utf-8')

def escape(text):
    """
    Used by the gettext.js template to escape translated strings
    so they don't break the script.
    """
    text = text.replace("'", "\\'")
    text = text.replace('\r\n', '\\n')
    text = text.replace('\r', '\\n')
    text = text.replace('\n', '\\n')
    return text


def compress(contents, request):
    request.setHeader('content-encoding', 'gzip')
    compress = zlib.compressobj(6, zlib.DEFLATED, zlib.MAX_WBITS + 16, zlib.DEF_MEM_LEVEL, 0)
    contents = compress.compress(contents)
    contents += compress.flush()
    return contents


class Template(MakoTemplate):
    """
    A template that adds some built-ins to the rendering
    """
    builtins = {'_': _,
     'escape': escape,
     'version': common.get_version()}

    def render(self, *args, **data):
        data.update(self.builtins)
        rendered = MakoTemplate.render_unicode(self, *args, **data)
        return rendered.encode('utf-8', 'replace')