# Embedded file name: deluge\ui\web\web.py
import os
from deluge.ui.ui import _UI, UI
from optparse import OptionGroup

class WebUI(UI):

    def __init__(self, args):
        import server
        deluge_web = server.DelugeWeb()
        deluge_web.start()


class Web(_UI):
    help = 'Starts the Deluge web interface'

    def __init__(self):
        super(Web, self).__init__('web')
        self.__server = None
        group = OptionGroup(self.parser, 'Web Options')
        group.add_option('-b', '--base', dest='base', help='Set the base path that the ui is running on (proxying)', action='store', default=None)
        group.add_option('-f', '--fork', dest='fork', help='Fork the web interface process into the background', action='store_true', default=False)
        group.add_option('-i', '--interface', dest='interface', type='str', help='Binds the webserver to a specific IP address', action='store', default=None)
        group.add_option('-p', '--port', dest='port', type='int', help='Sets the port to be used for the webserver', action='store', default=None)
        group.add_option('--profile', dest='profile', help='Profile the web server code', action='store_true', default=False)
        try:
            import OpenSSL
        except:
            pass
        else:
            group.add_option('--no-ssl', dest='ssl', action='store_false', help='Forces the webserver to disable ssl', default=False)
            group.add_option('--ssl', dest='ssl', action='store_true', help='Forces the webserver to use ssl', default=False)

        self.parser.add_option_group(group)
        return

    @property
    def server(self):
        return self.__server

    def start(self):
        super(Web, self).start()
        import deluge.common
        if self.options.fork and not deluge.common.windows_check():
            if os.fork():
                os._exit(0)
            os.setsid()
            if os.fork():
                os._exit(0)
            import deluge.configmanager
            os.chdir(deluge.configmanager.get_config_dir())
        import server
        self.__server = server.DelugeWeb()
        if self.options.base:
            self.server.base = self.options.base
        if self.options.interface:
            self.server.interface = self.options.interface
        if self.options.port:
            self.server.port = self.options.port
        if self.options.ssl:
            self.server.https = self.options.ssl
        if self.options.profile:
            import hotshot
            hsp = hotshot.Profile(deluge.configmanager.get_config_dir('deluge-web.profile'))
            hsp.start()
        self.server.install_signal_handlers()
        self.server.start()
        if self.options.profile:
            hsp.stop()
            hsp.close()
            import hotshot.stats
            stats = hotshot.stats.load(deluge.configmanager.get_config_dir('deluge-web.profile'))
            stats.strip_dirs()
            stats.sort_stats('time', 'calls')
            stats.print_stats(400)


def start():
    web = Web()
    web.start()