/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.IValueArithmetic;
import moze_intel.projecte.emc.IValueGenerator;
import moze_intel.projecte.emc.collector.AbstractMappingCollector;
import moze_intel.projecte.utils.PELogger;

public abstract class GraphMapper<T, V extends Comparable<V>>
extends AbstractMappingCollector<T, V>
implements IValueGenerator<T, V> {
    protected static final boolean DEBUG_GRAPHMAPPER = false;
    protected IValueArithmetic<V> arithmetic;
    protected Map<T, Conversion> overwriteConversion = Maps.newHashMap();
    protected Map<T, List<Conversion>> conversionsFor = Maps.newHashMap();
    protected Map<T, List<Conversion>> usedIn = Maps.newHashMap();
    protected Map<T, V> fixValueBeforeInherit = Maps.newHashMap();
    protected Map<T, V> fixValueAfterInherit = Maps.newHashMap();
    protected Map<T, Integer> noDependencyConversionCount = Maps.newHashMap();

    public GraphMapper(IValueArithmetic<V> arithmetic) {
        this.arithmetic = arithmetic;
    }

    protected static void debugFormat(String format, Object ... args) {
    }

    protected static void debugPrintln(String s) {
        GraphMapper.debugFormat("%s", s);
    }

    protected static <K, V> List<V> getOrCreateList(Map<K, List<V>> map, K key) {
        List<Object> list;
        if (map.containsKey(key)) {
            list = map.get(key);
        } else {
            list = new LinkedList();
            map.put(key, list);
        }
        return list;
    }

    protected List<Conversion> getConversionsFor(T something) {
        return GraphMapper.getOrCreateList(this.conversionsFor, something);
    }

    protected List<Conversion> getUsesFor(T something) {
        return GraphMapper.getOrCreateList(this.usedIn, something);
    }

    protected int getNoDependencyConversionCountFor(T something) {
        Integer count = this.noDependencyConversionCount.get(something);
        if (count == null) {
            return 0;
        }
        return count;
    }

    protected void increaseNoDependencyConversionCountFor(T something) {
        this.noDependencyConversionCount.put(something, this.getNoDependencyConversionCountFor(something) + 1);
    }

    protected void addConversionToIngredientUsages(Conversion conversion) {
        for (Map.Entry ingredient : conversion.ingredientsWithAmount.entrySet()) {
            List<Conversion> usesForIngredient = this.getUsesFor(ingredient.getKey());
            if (ingredient.getValue() == null) {
                throw new IllegalArgumentException("ingredient amount value has to be != null");
            }
            usesForIngredient.add(conversion);
        }
    }

    @Override
    public void addConversion(int outnumber, T output, Map<T, Integer> ingredientsWithAmount) {
        ingredientsWithAmount = Maps.newHashMap(ingredientsWithAmount);
        if (output == null || ingredientsWithAmount.containsKey(null)) {
            PELogger.logWarn(String.format("Ignoring Recipe because of invalid ingredient or output: %s -> %dx%s", ingredientsWithAmount, outnumber, output));
            return;
        }
        if (outnumber <= 0) {
            throw new IllegalArgumentException("outnumber has to be > 0!");
        }
        Conversion conversion = new Conversion(output, outnumber, ingredientsWithAmount);
        conversion.value = this.arithmetic.getZero();
        if (this.getConversionsFor(output).contains(conversion)) {
            return;
        }
        this.getConversionsFor(output).add(conversion);
        if (ingredientsWithAmount.size() == 0) {
            this.increaseNoDependencyConversionCountFor(output);
        }
        this.addConversionToIngredientUsages(conversion);
    }

    @Override
    public void setValueBefore(T something, V value) {
        if (something == null) {
            return;
        }
        if (this.fixValueBeforeInherit.containsKey(something)) {
            PELogger.logWarn("Overwriting fixValueBeforeInherit for " + something + ":" + this.fixValueBeforeInherit.get(something) + " to " + value);
        }
        this.fixValueBeforeInherit.put(something, value);
        this.fixValueAfterInherit.remove(something);
    }

    @Override
    public void setValueAfter(T something, V value) {
        if (something == null) {
            return;
        }
        if (this.fixValueAfterInherit.containsKey(something)) {
            PELogger.logWarn("Overwriting fixValueAfterInherit for " + something + ":" + this.fixValueAfterInherit.get(something) + " to " + value);
        }
        this.fixValueAfterInherit.put(something, value);
    }

    @Override
    public void setValueFromConversion(int outnumber, T something, Map<T, Integer> ingredientsWithAmount) {
        if (something == null || ingredientsWithAmount.containsKey(null)) {
            PELogger.logWarn(String.format("Ignoring setValueFromConversion because of invalid ingredient or output: %s -> %dx%s", ingredientsWithAmount, outnumber, something));
            return;
        }
        if (outnumber <= 0) {
            throw new IllegalArgumentException("outnumber has to be > 0!");
        }
        Conversion conversion = new Conversion(something, outnumber, ingredientsWithAmount);
        if (this.overwriteConversion.containsKey(something)) {
            Conversion oldConversion = this.overwriteConversion.get(something);
            PELogger.logWarn("Overwriting setValueFromConversion " + this.overwriteConversion.get(something) + " with " + conversion);
            for (T ingredient : ingredientsWithAmount.keySet()) {
                this.getUsesFor(ingredient).remove(oldConversion);
            }
        }
        this.addConversionToIngredientUsages(conversion);
        this.overwriteConversion.put(something, conversion);
    }

    @Override
    public abstract Map<T, V> generateValues();

    protected class Conversion {
        T output;
        int outnumber = 1;
        V value;
        Map<T, Integer> ingredientsWithAmount;

        protected Conversion(T output) {
            this.value = GraphMapper.this.arithmetic.getZero();
            this.output = output;
        }

        protected Conversion(T output, int outnumber, Map<T, Integer> ingredientsWithAmount) {
            this(output);
            this.outnumber = outnumber;
            this.ingredientsWithAmount = ingredientsWithAmount;
        }

        public void markInvalid() {
            if (this.ingredientsWithAmount != null) {
                this.ingredientsWithAmount.clear();
                this.ingredientsWithAmount = null;
            }
            this.value = GraphMapper.this.arithmetic.getZero();
        }

        public String toString() {
            return "" + this.value + " + " + this.ingredientsToString() + " => " + this.outnumber + "*" + this.output;
        }

        public String ingredientsToString() {
            if (this.ingredientsWithAmount == null || this.ingredientsWithAmount.size() == 0) {
                return "nothing";
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            Iterator iter = this.ingredientsWithAmount.entrySet().iterator();
            if (iter.hasNext()) {
                Map.Entry entry = iter.next();
                sb.append(entry.getValue()).append("*").append(entry.getKey().toString());
                while (iter.hasNext()) {
                    entry = iter.next();
                    sb.append(" + ").append(entry.getValue()).append("*").append(entry.getKey().toString());
                }
            }
            return sb.toString();
        }

        public boolean equals(Conversion other) {
            if (this.output.equals(other.output) && this.value.equals(other.value)) {
                if (this.ingredientsWithAmount == null || this.ingredientsWithAmount.size() == 0) {
                    return other.ingredientsWithAmount == null || other.ingredientsWithAmount.size() == 0;
                }
                return this.ingredientsWithAmount.equals(other.ingredientsWithAmount);
            }
            return false;
        }
    }
}

