/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.emc.IngredientMap;
import moze_intel.projecte.emc.NormalizedSimpleStack;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import moze_intel.projecte.gameObjs.customRecipes.RecipeShapedKleinStar;
import moze_intel.projecte.gameObjs.customRecipes.RecipeShapelessHidden;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CraftingMapper
implements IEMCMapper<NormalizedSimpleStack, Integer> {
    List<IRecipeMapper> recipeMappers = Arrays.asList(new VanillaRecipeMapper(), new VanillaOreRecipeMapper(), new PECustomRecipeMapper());
    Set<Class> canNotMap = Sets.newHashSet();
    Map<Class, Integer> recipeCount = Maps.newHashMap();

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Integer> mapper, Configuration config) {
        this.recipeCount.clear();
        this.canNotMap.clear();
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            boolean handled = false;
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput == null) continue;
            NormalizedSimpleStack recipeOutputNorm = NormalizedSimpleStack.getFor(recipeOutput);
            for (IRecipeMapper recipeMapper : this.recipeMappers) {
                if (!config.getBoolean("enable" + recipeMapper.getName(), "IRecipeImplementations", true, recipeMapper.getDescription()) || !recipeMapper.canHandle(recipe)) continue;
                handled = true;
                Iterable<CraftingIngredients> craftingIngredientIterable = recipeMapper.getIngredientsFor(recipe);
                if (craftingIngredientIterable != null) {
                    for (CraftingIngredients variation : craftingIngredientIterable) {
                        IngredientMap<NormalizedSimpleStack> ingredientMap = new IngredientMap<NormalizedSimpleStack>();
                        for (ItemStack itemStack : variation.fixedIngredients) {
                            if (itemStack == null || itemStack.func_77973_b() == null) continue;
                            if (itemStack.func_77973_b().hasContainerItem(itemStack)) {
                                ingredientMap.addIngredient(NormalizedSimpleStack.getFor(itemStack.func_77973_b().getContainerItem(itemStack)), -1);
                            }
                            ingredientMap.addIngredient(NormalizedSimpleStack.getFor(itemStack), 1);
                        }
                        for (Iterable iterable : variation.multiIngredients) {
                            NormalizedSimpleStack normalizedSimpleStack = NormalizedSimpleStack.createFake(iterable.toString());
                            ingredientMap.addIngredient(normalizedSimpleStack, 1);
                            for (ItemStack stack : iterable) {
                                if (stack == null || stack.func_77973_b() == null) continue;
                                IngredientMap<NormalizedSimpleStack> groupIngredientMap = new IngredientMap<NormalizedSimpleStack>();
                                if (stack.func_77973_b().hasContainerItem(stack)) {
                                    groupIngredientMap.addIngredient(NormalizedSimpleStack.getFor(stack.func_77973_b().getContainerItem(stack)), -1);
                                }
                                groupIngredientMap.addIngredient(NormalizedSimpleStack.getFor(stack), 1);
                                mapper.addConversion(1, normalizedSimpleStack, groupIngredientMap.getMap());
                            }
                        }
                        if (recipeOutput.field_77994_a > 0) {
                            mapper.addConversion(recipeOutput.field_77994_a, recipeOutputNorm, ingredientMap.getMap());
                            continue;
                        }
                        PELogger.logWarn("Ignoring Recipe because outnumber <= 0: " + ingredientMap.getMap().toString() + " -> " + recipeOutput);
                    }
                    break;
                }
                PELogger.logWarn("RecipeMapper " + recipeMapper + " failed to map Recipe" + recipe);
                break;
            }
            if (!handled) {
                if (this.canNotMap.contains(recipe.getClass())) continue;
                this.canNotMap.add(recipe.getClass());
                PELogger.logWarn("Can not map Crafting Recipes with Type: " + recipe.getClass().getName());
                continue;
            }
            int count = 0;
            if (this.recipeCount.containsKey(recipe.getClass())) {
                count = this.recipeCount.get(recipe.getClass());
            }
            this.recipeCount.put(recipe.getClass(), ++count);
        }
        PELogger.logInfo("CraftingMapper Statistics:");
        for (Map.Entry<Class, Integer> entry : this.recipeCount.entrySet()) {
            PELogger.logInfo(String.format("Found %d Recipes of Type %s", entry.getValue(), entry.getKey()));
        }
    }

    @Override
    public String getName() {
        return "CraftingMapper";
    }

    @Override
    public String getDescription() {
        return "Add Conversions for Crafting Recipes gathered from net.minecraft.item.crafting.CraftingManager";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    protected static class PECustomRecipeMapper
    implements IRecipeMapper {
        protected PECustomRecipeMapper() {
        }

        @Override
        public String getName() {
            return "PECustomRecipeMapper";
        }

        @Override
        public String getDescription() {
            return "Maps custom IRecipe's from ProjectE";
        }

        @Override
        public boolean canHandle(IRecipe recipe) {
            return recipe instanceof RecipeShapedKleinStar || recipe instanceof RecipeShapelessHidden;
        }

        @Override
        public Iterable<CraftingIngredients> getIngredientsFor(IRecipe recipe) {
            List<ItemStack> recipeItems = null;
            if (recipe instanceof RecipeShapedKleinStar) {
                recipeItems = Arrays.asList(((RecipeShapedKleinStar)recipe).recipeItems);
            } else if (recipe instanceof RecipeShapelessHidden) {
                recipeItems = ((RecipeShapelessHidden)recipe).getInput();
            }
            LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
            for (Object t : recipeItems) {
                if (t == null) continue;
                if (t instanceof ItemStack) {
                    ItemStack recipeItem = (ItemStack)t;
                    inputs.add(recipeItem);
                    continue;
                }
                PELogger.logWarn("Illegal Ingredient in Crafting Recipe: " + t.toString());
            }
            return Arrays.asList(new CraftingIngredients(inputs, new LinkedList<Iterable<ItemStack>>()));
        }
    }

    protected static class VanillaOreRecipeMapper
    implements IRecipeMapper {
        protected VanillaOreRecipeMapper() {
        }

        @Override
        public String getName() {
            return "VanillaOreRecipeMapper";
        }

        @Override
        public String getDescription() {
            return "Maps `IRecipe` crafting recipes that extend `ShapedOreRecipe` or `ShapelessOreRecipe`. This includes CraftingRecipes that use OreDictionary ingredients.";
        }

        @Override
        public boolean canHandle(IRecipe recipe) {
            return recipe instanceof ShapedOreRecipe || recipe instanceof ShapelessOreRecipe;
        }

        @Override
        public Iterable<CraftingIngredients> getIngredientsFor(IRecipe recipe) {
            LinkedList inputs = new LinkedList();
            ArrayList recipeItems = null;
            if (recipe instanceof ShapedOreRecipe) {
                recipeItems = Arrays.asList(((ShapedOreRecipe)recipe).getInput());
            } else if (recipe instanceof ShapelessOreRecipe) {
                recipeItems = ((ShapelessOreRecipe)recipe).getInput();
            }
            if (recipeItems == null) {
                return null;
            }
            ArrayList variableInputs = Lists.newArrayList();
            ArrayList fixedInputs = Lists.newArrayList();
            for (Object recipeItem : recipeItems) {
                if (recipeItem instanceof ItemStack) {
                    fixedInputs.add((ItemStack)recipeItem);
                    continue;
                }
                if (!(recipeItem instanceof Collection)) continue;
                LinkedList<ItemStack> recipeItemOptions = new LinkedList<ItemStack>();
                Collection recipeItemCollection = (Collection)recipeItem;
                if (recipeItemCollection.size() == 1) {
                    Object element = recipeItemCollection.iterator().next();
                    if (element instanceof ItemStack) {
                        fixedInputs.add((ItemStack)element);
                        continue;
                    }
                    PELogger.logWarn("Can not map recipe " + recipe + " because found " + element.toString() + " instead of ItemStack");
                    return null;
                }
                for (Object option : recipeItemCollection) {
                    if (option instanceof ItemStack) {
                        recipeItemOptions.add((ItemStack)option);
                        continue;
                    }
                    PELogger.logWarn("Can not map recipe " + recipe + " because found " + option.toString() + " instead of ItemStack");
                    return null;
                }
                variableInputs.add(recipeItemOptions);
            }
            return Arrays.asList(new CraftingIngredients(fixedInputs, variableInputs));
        }
    }

    protected static class VanillaRecipeMapper
    implements IRecipeMapper {
        protected VanillaRecipeMapper() {
        }

        @Override
        public String getName() {
            return "VanillaRecipeMapper";
        }

        @Override
        public String getDescription() {
            return "Maps `IRecipe` crafting recipes that extend `ShapedRecipes` or `ShapelessRecipes`";
        }

        @Override
        public boolean canHandle(IRecipe recipe) {
            return recipe instanceof ShapedRecipes || recipe instanceof ShapelessRecipes;
        }

        @Override
        public Iterable<CraftingIngredients> getIngredientsFor(IRecipe recipe) {
            List recipeItems = null;
            if (recipe instanceof ShapedRecipes) {
                recipeItems = Arrays.asList(((ShapedRecipes)recipe).field_77574_d);
            } else if (recipe instanceof ShapelessRecipes) {
                recipeItems = ((ShapelessRecipes)recipe).field_77579_b;
            }
            LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
            for (Object o : recipeItems) {
                if (o == null) continue;
                if (o instanceof ItemStack) {
                    ItemStack recipeItem = (ItemStack)o;
                    inputs.add(recipeItem);
                    continue;
                }
                PELogger.logWarn("Illegal Ingredient in Crafting Recipe: " + o.toString());
            }
            return Arrays.asList(new CraftingIngredients(inputs, new LinkedList<Iterable<ItemStack>>()));
        }
    }

    public static class CraftingIngredients {
        public Iterable<ItemStack> fixedIngredients;
        public Iterable<Iterable<ItemStack>> multiIngredients;

        public CraftingIngredients(Iterable<ItemStack> fixedIngredients, Iterable<Iterable<ItemStack>> multiIngredients) {
            this.fixedIngredients = fixedIngredients;
            this.multiIngredients = multiIngredients;
        }
    }

    public static interface IRecipeMapper {
        public String getName();

        public String getDescription();

        public boolean canHandle(IRecipe var1);

        public Iterable<CraftingIngredients> getIngredientsFor(IRecipe var1);
    }
}

