/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import com.google.common.collect.Lists;
import java.util.List;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.items.PhilosophersStone;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TransmutationRenderingEvent {
    private Minecraft mc = Minecraft.func_71410_x();
    private final List<AxisAlignedBB> renderList = Lists.newArrayList();
    private double playerX;
    private double playerY;
    private double playerZ;
    private IBlockState transmutationResult;

    @SubscribeEvent
    public void preDrawHud(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && this.transmutationResult != null) {
            if (FluidRegistry.lookupFluidForBlock((Block)this.transmutationResult.func_177230_c()) != null) {
                TextureAtlasSprite sprite = this.mc.func_147117_R().func_110572_b(FluidRegistry.lookupFluidForBlock((Block)this.transmutationResult.func_177230_c()).getFlowing().toString());
                this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                Tessellator tess = Tessellator.func_178181_a();
                WorldRenderer render = tess.func_178180_c();
                render.func_178970_b();
                render.func_178985_a(0.0, 0.0, 0.0, (double)sprite.func_94209_e(), (double)sprite.func_94206_g());
                render.func_178985_a(0.0, 16.0, 0.0, (double)sprite.func_94209_e(), (double)sprite.func_94210_h());
                render.func_178985_a(16.0, 16.0, 0.0, (double)sprite.func_94212_f(), (double)sprite.func_94210_h());
                render.func_178985_a(16.0, 0.0, 0.0, (double)sprite.func_94212_f(), (double)sprite.func_94206_g());
                tess.func_78381_a();
            } else {
                RenderHelper.func_74519_b();
                this.mc.func_175599_af().func_175042_a(ItemHelper.stateToStack(this.transmutationResult, 1), 0, 0);
                RenderHelper.func_74518_a();
            }
        }
    }

    @SubscribeEvent
    public void onOverlay(DrawBlockHighlightEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        World world = player.field_70170_p;
        ItemStack stack = player.func_70694_bm();
        if (stack == null || stack.func_77973_b() != ObjHandler.philosStone || !stack.func_77942_o()) {
            this.transmutationResult = null;
            return;
        }
        this.playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.partialTicks;
        this.playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.partialTicks;
        this.playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.partialTicks;
        MovingObjectPosition mop = event.target;
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            IBlockState current = world.func_180495_p(mop.func_178782_a());
            this.transmutationResult = WorldTransmutations.getWorldTransmutation(current, player.func_70093_af());
            if (this.transmutationResult != null) {
                byte charge = ((ItemMode)stack.func_77973_b()).getCharge(stack);
                byte mode = ((ItemMode)stack.func_77973_b()).getMode(stack);
                for (BlockPos pos : PhilosophersStone.getAffectedPositions(world, mop.func_178782_a(), (EntityPlayer)player, mop.field_178784_b, mode, charge)) {
                    this.addBlockToRenderList(pos);
                }
                this.drawAll();
                this.renderList.clear();
            }
        } else {
            this.transmutationResult = null;
        }
    }

    private void drawAll() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179090_x();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(ProjectEConfig.pulsatingOverlay ? this.getPulseProportion() * 0.6f : 0.35f));
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer r = tessellator.func_178180_c();
        for (AxisAlignedBB b : this.renderList) {
            r.func_178970_b();
            r.func_178984_b(b.field_72340_a, b.field_72337_e, b.field_72339_c);
            r.func_178984_b(b.field_72336_d, b.field_72337_e, b.field_72339_c);
            r.func_178984_b(b.field_72336_d, b.field_72337_e, b.field_72334_f);
            r.func_178984_b(b.field_72340_a, b.field_72337_e, b.field_72334_f);
            tessellator.func_78381_a();
            r.func_178970_b();
            r.func_178984_b(b.field_72340_a, b.field_72338_b, b.field_72339_c);
            r.func_178984_b(b.field_72336_d, b.field_72338_b, b.field_72339_c);
            r.func_178984_b(b.field_72336_d, b.field_72338_b, b.field_72334_f);
            r.func_178984_b(b.field_72340_a, b.field_72338_b, b.field_72334_f);
            tessellator.func_78381_a();
            r.func_178970_b();
            r.func_178984_b(b.field_72336_d, b.field_72337_e, b.field_72334_f);
            r.func_178984_b(b.field_72340_a, b.field_72337_e, b.field_72334_f);
            r.func_178984_b(b.field_72340_a, b.field_72338_b, b.field_72334_f);
            r.func_178984_b(b.field_72336_d, b.field_72338_b, b.field_72334_f);
            tessellator.func_78381_a();
            r.func_178970_b();
            r.func_178984_b(b.field_72336_d, b.field_72338_b, b.field_72339_c);
            r.func_178984_b(b.field_72340_a, b.field_72338_b, b.field_72339_c);
            r.func_178984_b(b.field_72340_a, b.field_72337_e, b.field_72339_c);
            r.func_178984_b(b.field_72336_d, b.field_72337_e, b.field_72339_c);
            tessellator.func_78381_a();
            r.func_178970_b();
            r.func_178984_b(b.field_72340_a, b.field_72337_e, b.field_72334_f);
            r.func_178984_b(b.field_72340_a, b.field_72337_e, b.field_72339_c);
            r.func_178984_b(b.field_72340_a, b.field_72338_b, b.field_72339_c);
            r.func_178984_b(b.field_72340_a, b.field_72338_b, b.field_72334_f);
            tessellator.func_78381_a();
            r.func_178970_b();
            r.func_178984_b(b.field_72336_d, b.field_72337_e, b.field_72334_f);
            r.func_178984_b(b.field_72336_d, b.field_72337_e, b.field_72339_c);
            r.func_178984_b(b.field_72336_d, b.field_72338_b, b.field_72339_c);
            r.func_178984_b(b.field_72336_d, b.field_72338_b, b.field_72334_f);
            tessellator.func_78381_a();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private void addBlockToRenderList(BlockPos pos) {
        AxisAlignedBB box = new AxisAlignedBB((double)((float)pos.func_177958_n() - 0.02f), (double)((float)pos.func_177956_o() - 0.02f), (double)((float)pos.func_177952_p() - 0.02f), (double)((float)pos.func_177958_n() + 1.02f), (double)((float)pos.func_177956_o() + 1.02f), (double)((float)pos.func_177952_p() + 1.02f));
        box = box.func_72317_d(-this.playerX, -this.playerY, -this.playerZ);
        this.renderList.add(box);
    }

    private float getPulseProportion() {
        return (float)(0.5 * Math.sin((double)System.currentTimeMillis() / 350.0) + 0.5);
    }
}

