/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import moze_intel.projecte.PECore;
import moze_intel.projecte.api.item.IExtraFunction;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class MercurialEye
extends ItemMode
implements IExtraFunction {
    private final int NORMAL_MODE = 0;
    private final int TRANSMUTATION_MODE = 1;
    private final double WALL_MODE = Math.sin(Math.toRadians(45.0));

    public MercurialEye() {
        super("mercurial_eye", (byte)4, new String[]{"Normal", "Transmutation"});
        this.setNoRepair();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            MovingObjectPosition mop = this.func_77621_a(world, player, false);
            if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return stack;
            }
            ItemStack[] inventory = this.getInventory(stack);
            if (inventory[0] == null || inventory[1] == null) {
                return stack;
            }
            IBlockState newState = ItemHelper.stackToState(inventory[1]);
            if (newState == null || newState.func_177230_c() == Blocks.field_150350_a) {
                return stack;
            }
            double kleinEmc = ItemPE.getEmc(inventory[0]);
            int reqEmc = EMCHelper.getEmcValue(inventory[1]);
            byte charge = this.getCharge(stack);
            byte mode = this.getMode(stack);
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            Vec3 look = player.func_70040_Z();
            int dX = 0;
            int dY = 0;
            int dZ = 0;
            boolean lookingDown = look.field_72448_b >= -1.0 && look.field_72448_b <= -this.WALL_MODE;
            boolean lookingUp = look.field_72448_b <= 1.0 && look.field_72448_b >= this.WALL_MODE;
            boolean lookingAlongZ = facing == 0 || facing == 2;
            BlockPos pos = mop.func_178782_a();
            AxisAlignedBB box = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            switch (mop.field_178784_b) {
                case UP: {
                    if (lookingDown || mode == 1) {
                        box = box.func_72314_b((double)charge, 0.0, (double)charge);
                        dY = 1;
                        break;
                    }
                    if (lookingAlongZ) {
                        box = box.func_72314_b((double)charge, (double)(charge * 2), 0.0).func_72317_d(0.0, (double)charge, 0.0);
                        break;
                    }
                    box = box.func_72314_b(0.0, (double)(charge * 2), (double)charge).func_72317_d(0.0, (double)charge, 0.0);
                    break;
                }
                case DOWN: {
                    if (lookingUp || mode == 1) {
                        box = box.func_72314_b((double)charge, 0.0, (double)charge);
                        dY = -1;
                        break;
                    }
                    if (lookingAlongZ) {
                        box = box.func_72314_b((double)charge, (double)(charge * 2), 0.0).func_72317_d(0.0, (double)(-charge), 0.0);
                        break;
                    }
                    box = box.func_72314_b(0.0, (double)(charge * 2), (double)charge).func_72317_d(0.0, (double)(-charge), 0.0);
                    break;
                }
                case EAST: {
                    box = box.func_72314_b(0.0, (double)charge, (double)charge);
                    dX = 1;
                    break;
                }
                case WEST: {
                    box = box.func_72314_b(0.0, (double)charge, (double)charge);
                    dX = -1;
                    break;
                }
                case SOUTH: {
                    box = box.func_72314_b((double)charge, (double)charge, 0.0);
                    dZ = 1;
                    break;
                }
                case NORTH: {
                    box = box.func_72314_b((double)charge, (double)charge, 0.0);
                    dZ = -1;
                }
            }
            if (0 == mode) {
                box = box.func_72317_d((double)dX, (double)dY, (double)dZ);
            }
            if (box != null) {
                for (BlockPos currentPos : WorldHelper.getPositionsFromBox(box)) {
                    int difference;
                    IBlockState oldState = world.func_180495_p(currentPos);
                    Block oldBlock = oldState.func_177230_c();
                    if (mode == 0 && oldBlock == Blocks.field_150350_a) {
                        if (kleinEmc < (double)reqEmc) break;
                        if (!PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, currentPos, newState)) continue;
                        this.removeKleinEMC(stack, reqEmc);
                        kleinEmc -= (double)reqEmc;
                        continue;
                    }
                    if (mode != 1 || oldState == newState || oldBlock == Blocks.field_150350_a || world.func_175625_s(currentPos) != null || !EMCHelper.doesItemHaveEmc(ItemHelper.stateToStack(oldState, 1))) continue;
                    int emc = EMCHelper.getEmcValue(ItemHelper.stateToStack(oldState, 1));
                    if (emc > reqEmc) {
                        if (!PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, currentPos, newState)) continue;
                        difference = emc - reqEmc;
                        kleinEmc += MathHelper.func_151237_a((double)kleinEmc, (double)0.0, (double)EMCHelper.getKleinStarMaxEmc(inventory[0]));
                        this.addKleinEMC(stack, difference);
                        continue;
                    }
                    if (emc < reqEmc) {
                        difference = reqEmc - emc;
                        if (!(kleinEmc >= (double)difference) || !PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, currentPos, newState)) continue;
                        kleinEmc -= (double)difference;
                        this.removeKleinEMC(stack, difference);
                        continue;
                    }
                    PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, currentPos, newState);
                }
                player.field_70170_p.func_72956_a((Entity)player, "projecte:item.pepower", 1.0f, 0.8f + 0.2f / (float)this.numCharges * (float)charge);
            }
        }
        return stack;
    }

    private void addKleinEMC(ItemStack eye, int amount) {
        NBTTagList list = eye.func_77978_p().func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            if (nbt.func_74771_c("Slot") != 0) continue;
            ItemStack kleinStar = ItemStack.func_77949_a((NBTTagCompound)nbt);
            NBTTagCompound tag = nbt.func_74775_l("tag");
            double newEmc = MathHelper.func_151237_a((double)(tag.func_74769_h("StoredEMC") + (double)amount), (double)0.0, (double)EMCHelper.getKleinStarMaxEmc(kleinStar));
            tag.func_74780_a("StoredEMC", newEmc);
            break;
        }
    }

    private void removeKleinEMC(ItemStack eye, int amount) {
        NBTTagList list = eye.func_77978_p().func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            if (nbt.func_74771_c("Slot") != 0) continue;
            NBTTagCompound tag = nbt.func_74775_l("tag");
            tag.func_74780_a("StoredEMC", tag.func_74769_h("StoredEMC") - (double)amount);
            break;
        }
    }

    private ItemStack[] getInventory(ItemStack eye) {
        ItemStack[] result = new ItemStack[2];
        if (eye.func_77942_o()) {
            NBTTagList list = eye.func_77978_p().func_150295_c("Items", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                result[nbt.func_74771_c((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)nbt);
            }
        }
        return result;
    }

    @Override
    public void doExtraFunction(ItemStack stack, EntityPlayer player) {
        player.openGui((Object)PECore.instance, 12, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }
}

