/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.item.IExtraFunction;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.gameObjs.entity.EntityMobRandomizer;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.ParticlePKT;
import moze_intel.projecte.utils.AchievementHandler;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PhilosophersStone
extends ItemMode
implements IProjectileShooter,
IExtraFunction {
    public PhilosophersStone() {
        super("philosophers_stone", (byte)4, new String[]{StatCollector.func_74838_a((String)"pe.philstone.mode1"), StatCollector.func_74838_a((String)"pe.philstone.mode2"), StatCollector.func_74838_a((String)"pe.philstone.mode3")});
        this.func_77642_a(this);
        this.setNoRepair();
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing sideHit, float px, float py, float pz) {
        if (world.field_72995_K) {
            return false;
        }
        IBlockState result = WorldTransmutations.getWorldTransmutation(world, pos, player.func_70093_af());
        if (result != null) {
            byte mode = this.getMode(stack);
            byte charge = this.getCharge(stack);
            for (BlockPos currentPos : PhilosophersStone.getAffectedPositions(world, pos, player, sideHit, mode, charge)) {
                PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, currentPos, result);
                if (world.field_73012_v.nextInt(8) != 0) continue;
                PacketHandler.sendToAllAround(new ParticlePKT(EnumParticleTypes.SMOKE_LARGE, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()), new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 32.0));
            }
            world.func_72956_a((Entity)player, "projecte:item.petransmute", 1.0f, 1.0f);
            PlayerHelper.swingItem(player);
        }
        return true;
    }

    @Override
    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        if (!world.field_72995_K) {
            player.func_71064_a((StatBase)AchievementHandler.PHIL_STONE, 1);
        }
    }

    @Override
    public boolean shootProjectile(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        world.func_72956_a((Entity)player, "projecte:item.petransmute", 1.0f, 1.0f);
        world.func_72838_d((Entity)new EntityMobRandomizer(world, player));
        return true;
    }

    @Override
    public void doExtraFunction(ItemStack stack, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.openGui((Object)PECore.instance, 13, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(String.format(StatCollector.func_74838_a((String)"pe.philstone.tooltip1"), ClientKeyHelper.getKeyName(PEKeybind.EXTRA_FUNCTION)));
    }

    public static Set<BlockPos> getAffectedPositions(World world, BlockPos pos, EntityPlayer player, EnumFacing sideHit, int mode, int charge) {
        HashSet ret = Sets.newHashSet();
        IBlockState targeted = world.func_180495_p(pos);
        Iterable<BlockPos> iterable = null;
        switch (mode) {
            case 0: {
                iterable = WorldHelper.getPositionsFromCorners(pos.func_177982_a(-charge, -charge, -charge), pos.func_177982_a(charge, charge, charge));
                break;
            }
            case 1: {
                if (sideHit == EnumFacing.UP || sideHit == EnumFacing.DOWN) {
                    iterable = WorldHelper.getPositionsFromCorners(pos.func_177982_a(-charge, 0, -charge), pos.func_177982_a(charge, 0, charge));
                    break;
                }
                if (sideHit == EnumFacing.EAST || sideHit == EnumFacing.WEST) {
                    iterable = WorldHelper.getPositionsFromCorners(pos.func_177982_a(0, -charge, -charge), pos.func_177982_a(0, charge, charge));
                    break;
                }
                if (sideHit != EnumFacing.SOUTH && sideHit != EnumFacing.NORTH) break;
                iterable = WorldHelper.getPositionsFromCorners(pos.func_177982_a(-charge, -charge, 0), pos.func_177982_a(charge, charge, 0));
                break;
            }
            case 2: {
                EnumFacing playerFacing = player.func_174811_aO();
                if (playerFacing.func_176740_k() == EnumFacing.Axis.Z) {
                    iterable = WorldHelper.getPositionsFromCorners(pos.func_177982_a(0, 0, -charge), pos.func_177982_a(0, 0, charge));
                    break;
                }
                if (playerFacing.func_176740_k() != EnumFacing.Axis.X) break;
                iterable = WorldHelper.getPositionsFromCorners(pos.func_177982_a(-charge, 0, 0), pos.func_177982_a(charge, 0, 0));
            }
        }
        if (iterable != null) {
            for (BlockPos currentPos : iterable) {
                if (world.func_180495_p(currentPos) != targeted) continue;
                ret.add(currentPos);
            }
        }
        return ret;
    }
}

