/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class Ignition
extends RingToggle
implements IBauble,
IPedestalItem,
IFireProtector,
IProjectileShooter {
    public Ignition() {
        super("ignition");
        this.setNoRepair();
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int inventorySlot, boolean par5) {
        if (world.field_72995_K || inventorySlot > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        super.func_77663_a(stack, world, entity, inventorySlot, par5);
        EntityPlayerMP player = (EntityPlayerMP)entity;
        if (stack.func_77952_i() != 0) {
            if (Ignition.getEmc(stack) == 0.0 && !Ignition.consumeFuel((EntityPlayer)player, stack, 64.0, false)) {
                stack.func_77964_b(0);
            } else {
                WorldHelper.igniteNearby(world, (EntityPlayer)player);
                Ignition.removeEmc(stack, 0.32f);
            }
        } else {
            WorldHelper.extinguishNearby(world, (EntityPlayer)player);
        }
    }

    @Override
    public void changeMode(EntityPlayer player, ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            if (Ignition.getEmc(stack) != 0.0 || Ignition.consumeFuel(player, stack, 64.0, false)) {
                stack.func_77964_b(1);
            }
        } else {
            stack.func_77964_b(0);
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            MovingObjectPosition mop = this.func_77621_a(world, player, false);
            if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && world.func_180495_p(mop.func_178782_a()).func_177230_c() instanceof BlockTNT && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, mop.func_178782_a())) {
                ((BlockTNT)world.func_180495_p(mop.func_178782_a()).func_177230_c()).func_180692_a(world, mop.func_178782_a(), world.func_180495_p(mop.func_178782_a()).func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)), (EntityLivingBase)player);
                world.func_175698_g(mop.func_178782_a());
            }
            world.func_72956_a((Entity)player, "projecte:item.pepower", 1.0f, 1.0f);
        }
        return stack;
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(World world, BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.ignitePedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_175625_s(pos);
            if (tile.getActivityCooldown() == 0) {
                List list = world.func_72872_a(EntityLiving.class, tile.getEffectBounds());
                for (EntityLiving living : list) {
                    living.func_70097_a(DamageSource.field_76372_a, 3.0f);
                    living.func_70015_d(8);
                }
                tile.setActivityCooldown(ProjectEConfig.ignitePedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.ignitePedCooldown != -1) {
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.ignition.pedestal1"));
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.ignition.pedestal2"), MathUtils.tickToSecFormatted(ProjectEConfig.ignitePedCooldown)));
        }
        return list;
    }

    @Override
    public boolean shootProjectile(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return false;
        }
        EntityFireProjectile fire = new EntityFireProjectile(world, player);
        world.func_72838_d((Entity)fire);
        return true;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, EntityPlayerMP player) {
        return true;
    }
}

