/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.proxies;

import java.lang.reflect.Method;
import java.util.Map;
import moze_intel.projecte.events.KeyPressEvent;
import moze_intel.projecte.events.PlayerRender;
import moze_intel.projecte.events.ToolTipEvent;
import moze_intel.projecte.events.TransmutationRenderingEvent;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.blocks.AlchemicalChest;
import moze_intel.projecte.gameObjs.blocks.Condenser;
import moze_intel.projecte.gameObjs.blocks.CondenserMK2;
import moze_intel.projecte.gameObjs.blocks.FuelBlock;
import moze_intel.projecte.gameObjs.blocks.MatterBlock;
import moze_intel.projecte.gameObjs.blocks.NovaCataclysm;
import moze_intel.projecte.gameObjs.blocks.NovaCatalyst;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.entity.EntityLavaProjectile;
import moze_intel.projecte.gameObjs.entity.EntityLensProjectile;
import moze_intel.projecte.gameObjs.entity.EntityLootBall;
import moze_intel.projecte.gameObjs.entity.EntityMobRandomizer;
import moze_intel.projecte.gameObjs.entity.EntityNovaCataclysmPrimed;
import moze_intel.projecte.gameObjs.entity.EntityNovaCatalystPrimed;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.entity.EntityWaterProjectile;
import moze_intel.projecte.gameObjs.items.KleinStar;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.gameObjs.tiles.CondenserMK2Tile;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.manual.ManualPageHandler;
import moze_intel.projecte.playerData.AlchBagProps;
import moze_intel.projecte.playerData.Transmutation;
import moze_intel.projecte.playerData.TransmutationProps;
import moze_intel.projecte.proxies.IProxy;
import moze_intel.projecte.rendering.ChestRenderer;
import moze_intel.projecte.rendering.CondenserMK2Renderer;
import moze_intel.projecte.rendering.CondenserRenderer;
import moze_intel.projecte.rendering.LayerModelYue;
import moze_intel.projecte.rendering.NovaCataclysmRenderer;
import moze_intel.projecte.rendering.NovaCatalystRenderer;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PELogger;
import moze_intel.projecte.utils.ReflectionHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ClientProxy
implements IProxy {
    @Override
    public void clearClientKnowledge() {
        Transmutation.clearKnowledge((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
    }

    @Override
    public TransmutationProps getClientTransmutationProps() {
        return TransmutationProps.getDataFor((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
    }

    @Override
    public AlchBagProps getClientBagProps() {
        return AlchBagProps.getDataFor((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
    }

    @Override
    public void registerKeyBinds() {
        ClientKeyHelper.registerMCBindings();
    }

    @Override
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)ObjHandler.novaCatalyst, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{NovaCatalyst.field_176246_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ObjHandler.novaCataclysm, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{NovaCataclysm.field_176246_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ObjHandler.alchChest, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{AlchemicalChest.FACING}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ObjHandler.condenser, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{Condenser.FACING}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ObjHandler.condenserMk2, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{CondenserMK2.FACING}).func_178441_a());
        this.registerCovalenceDust();
        this.registerBags();
        this.registerFuels();
        this.registerMatter();
        this.registerKlein();
        this.registerPowerStones();
        this.registerPowerItems();
        this.registerItem(ObjHandler.waterOrb);
        this.registerItem(ObjHandler.lavaOrb);
        this.registerItem(ObjHandler.lootBall);
        this.registerItem(ObjHandler.mobRandomizer);
        this.registerItem(ObjHandler.lensExplosive);
        this.registerItem(ObjHandler.windProjectile);
        this.registerItem(ObjHandler.fireProjectile);
        this.registerItem(ObjHandler.philosStone);
        this.registerItem(ObjHandler.repairTalisman);
        this.registerItem(ObjHandler.ironBand);
        this.registerItem(ObjHandler.dCatalyst);
        this.registerItem(ObjHandler.hyperLens);
        this.registerItem(ObjHandler.cataliticLens);
        this.registerItem(ObjHandler.tome);
        this.registerItem(ObjHandler.transmutationTablet);
        this.registerItem(ObjHandler.everTide);
        this.registerItem(ObjHandler.volcanite);
        this.registerItem(ObjHandler.dRod1);
        this.registerItem(ObjHandler.dRod2);
        this.registerItem(ObjHandler.dRod3);
        this.registerItem(ObjHandler.angelSmite);
        this.registerItem(ObjHandler.mercEye);
        this.registerItem(ObjHandler.dmPick);
        this.registerItem(ObjHandler.dmAxe);
        this.registerItem(ObjHandler.dmShovel);
        this.registerItem(ObjHandler.dmSword);
        this.registerItem(ObjHandler.dmHoe);
        this.registerItem(ObjHandler.dmShears);
        this.registerItem(ObjHandler.dmHammer);
        this.registerItem(ObjHandler.dmHelmet);
        this.registerItem(ObjHandler.dmChest);
        this.registerItem(ObjHandler.dmLegs);
        this.registerItem(ObjHandler.dmFeet);
        this.registerItem(ObjHandler.rmPick);
        this.registerItem(ObjHandler.rmAxe);
        this.registerItem(ObjHandler.rmShovel);
        this.registerItem(ObjHandler.rmSword);
        this.registerItem(ObjHandler.rmHoe);
        this.registerItem(ObjHandler.rmShears);
        this.registerItem(ObjHandler.rmHammer);
        this.registerItem(ObjHandler.rmKatar);
        this.registerItem(ObjHandler.rmStar);
        this.registerItem(ObjHandler.rmHelmet);
        this.registerItem(ObjHandler.rmChest);
        this.registerItem(ObjHandler.rmLegs);
        this.registerItem(ObjHandler.rmFeet);
        this.registerItem(ObjHandler.gemHelmet);
        this.registerItem(ObjHandler.gemChest);
        this.registerItem(ObjHandler.gemLegs);
        this.registerItem(ObjHandler.gemFeet);
        this.registerItem(ObjHandler.manual);
        this.registerBlock(ObjHandler.alchChest);
        this.registerBlock(ObjHandler.collectorMK2);
        this.registerBlock(ObjHandler.collectorMK3);
        this.registerBlock(ObjHandler.condenser);
        this.registerBlock(ObjHandler.condenserMk2);
        this.registerBlock(ObjHandler.confuseTorch);
        this.registerBlock(ObjHandler.dmFurnaceOff);
        this.registerBlock(ObjHandler.dmPedestal);
        this.registerBlock(ObjHandler.energyCollector);
        this.registerBlock(ObjHandler.novaCatalyst);
        this.registerBlock(ObjHandler.novaCataclysm);
        this.registerBlock(ObjHandler.relay);
        this.registerBlock(ObjHandler.relayMK2);
        this.registerBlock(ObjHandler.relayMK3);
        this.registerBlock(ObjHandler.rmFurnaceOff);
        this.registerBlock(ObjHandler.transmuteStone);
    }

    private void registerBlock(Block b) {
        String name = GameRegistry.findUniqueIdentifierFor((Block)b).name;
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)b), (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:" + name, "inventory"));
    }

    private void registerItem(Item i) {
        String name = GameRegistry.findUniqueIdentifierFor((Item)i).name;
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:" + name, "inventory"));
    }

    private void registerCovalenceDust() {
        ModelLoader.addVariantName((Item)ObjHandler.covalence, (String[])new String[]{"projecte:covalence_low", "projecte:covalence_medium", "projecte:covalence_high"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.covalence, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:covalence_low", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.covalence, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:covalence_medium", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.covalence, (int)2, (ModelResourceLocation)new ModelResourceLocation("projecte:covalence_high", "inventory"));
    }

    private void registerBags() {
        for (EnumDyeColor e : EnumDyeColor.values()) {
            ModelLoader.addVariantName((Item)ObjHandler.alchBag, (String[])new String[]{"projecte:bags/alchbag_" + e.func_176610_l()});
            ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.alchBag, (int)e.func_176765_a(), (ModelResourceLocation)new ModelResourceLocation("projecte:bags/alchbag_" + e.func_176610_l(), "inventory"));
        }
    }

    private void registerFuels() {
        for (FuelBlock.EnumFuelType e : FuelBlock.EnumFuelType.values()) {
            ModelLoader.addVariantName((Item)ObjHandler.fuels, (String[])new String[]{"projecte:" + e.func_176610_l()});
            ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.fuels, (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation("projecte:" + e.func_176610_l(), "inventory"));
            ModelLoader.addVariantName((Item)Item.func_150898_a((Block)ObjHandler.fuelBlock), (String[])new String[]{"projecte:" + e.func_176610_l() + "_block"});
            int meta = ObjHandler.fuelBlock.func_176201_c(ObjHandler.fuelBlock.func_176223_P().func_177226_a(FuelBlock.FUEL_PROP, (Comparable)((Object)e)));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ObjHandler.fuelBlock), (int)meta, (ModelResourceLocation)new ModelResourceLocation("projecte:" + e.func_176610_l() + "_block", "inventory"));
        }
    }

    private void registerMatter() {
        for (MatterBlock.EnumMatterType m : MatterBlock.EnumMatterType.values()) {
            ModelLoader.addVariantName((Item)ObjHandler.matter, (String[])new String[]{"projecte:" + m.func_176610_l()});
            ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.matter, (int)m.ordinal(), (ModelResourceLocation)new ModelResourceLocation("projecte:" + m.func_176610_l(), "inventory"));
            ModelLoader.addVariantName((Item)Item.func_150898_a((Block)ObjHandler.matterBlock), (String[])new String[]{"projecte:" + m.func_176610_l() + "_block"});
            int meta = ObjHandler.matterBlock.func_176201_c(ObjHandler.matterBlock.func_176223_P().func_177226_a(MatterBlock.TIER_PROP, (Comparable)((Object)m)));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ObjHandler.matterBlock), (int)meta, (ModelResourceLocation)new ModelResourceLocation("projecte:" + m.func_176610_l() + "_block", "inventory"));
        }
    }

    private void registerKlein() {
        for (KleinStar.EnumKleinTier e : KleinStar.EnumKleinTier.values()) {
            ModelLoader.addVariantName((Item)ObjHandler.kleinStars, (String[])new String[]{"projecte:stars/klein_star_" + e.name});
            ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.kleinStars, (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation("projecte:stars/klein_star_" + e.name, "inventory"));
        }
    }

    private void registerPowerStones() {
        ModelLoader.addVariantName((Item)ObjHandler.bodyStone, (String[])new String[]{"projecte:body_stone_off", "projecte:body_stone_on"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.bodyStone, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:body_stone_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.bodyStone, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:body_stone_on", "inventory"));
        ModelLoader.addVariantName((Item)ObjHandler.soulStone, (String[])new String[]{"projecte:soul_stone_off", "projecte:soul_stone_on"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.soulStone, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:soul_stone_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.soulStone, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:soul_stone_on", "inventory"));
        ModelLoader.addVariantName((Item)ObjHandler.mindStone, (String[])new String[]{"projecte:mind_stone_off", "projecte:mind_stone_on"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.mindStone, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:mind_stone_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.mindStone, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:mind_stone_on", "inventory"));
        ModelLoader.addVariantName((Item)ObjHandler.lifeStone, (String[])new String[]{"projecte:life_stone_off", "projecte:life_stone_on"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.lifeStone, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:life_stone_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.lifeStone, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:life_stone_on", "inventory"));
    }

    private void registerPowerItems() {
        ModelLoader.addVariantName((Item)ObjHandler.blackHole, (String[])new String[]{"projecte:bhb_off", "projecte:bhb_on"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.blackHole, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:bhb_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.blackHole, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:bhb_on", "inventory"));
        ModelLoader.addVariantName((Item)ObjHandler.harvestGod, (String[])new String[]{"projecte:harvgod_off", "projecte:harvgod_on"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.harvestGod, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:harvgod_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.harvestGod, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:harvgod_on", "inventory"));
        ModelLoader.addVariantName((Item)ObjHandler.eternalDensity, (String[])new String[]{"projecte:goed_off", "projecte:goed_on"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.eternalDensity, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:goed_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.eternalDensity, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:goed_on", "inventory"));
        ModelLoader.addVariantName((Item)ObjHandler.timeWatch, (String[])new String[]{"projecte:timewatch_off", "projecte:timewatch_on"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.timeWatch, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:timewatch_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.timeWatch, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:timewatch_on", "inventory"));
        ModelLoader.addVariantName((Item)ObjHandler.ignition, (String[])new String[]{"projecte:ignition_off", "projecte:ignition_on"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.ignition, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:ignition_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.ignition, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:ignition_on", "inventory"));
        ModelLoader.addVariantName((Item)ObjHandler.zero, (String[])new String[]{"projecte:zero_off", "projecte:zero_on"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.zero, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:zero_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.zero, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:zero_on", "inventory"));
        ModelLoader.addVariantName((Item)ObjHandler.swrg, (String[])new String[]{"projecte:swrg_off", "projecte:swrg_fly", "projecte:swrg_repel", "projecte:swrg_both"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.swrg, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:swrg_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.swrg, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:swrg_fly", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.swrg, (int)2, (ModelResourceLocation)new ModelResourceLocation("projecte:swrg_repel", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.swrg, (int)3, (ModelResourceLocation)new ModelResourceLocation("projecte:swrg_both", "inventory"));
        ModelLoader.addVariantName((Item)ObjHandler.voidRing, (String[])new String[]{"projecte:voidring_off", "projecte:voidring_on"});
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.voidRing, (int)0, (ModelResourceLocation)new ModelResourceLocation("projecte:voidring_off", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ObjHandler.voidRing, (int)1, (ModelResourceLocation)new ModelResourceLocation("projecte:voidring_on", "inventory"));
        ModelLoader.addVariantName((Item)ObjHandler.arcana, (String[])new String[]{"projecte:arcana_zero_off", "projecte:arcana_zero_on", "projecte:arcana_ignition_off", "projecte:arcana_ignition_on", "projecte:arcana_harv_off", "projecte:arcana_harv_on", "projecte:arcana_swrg_off", "projecte:arcana_swrg_on"});
        ModelLoader.setCustomMeshDefinition((Item)ObjHandler.arcana, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                String modelName;
                boolean active = stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("Active");
                switch (stack.func_77952_i()) {
                    case 0: {
                        modelName = active ? "arcana_zero_on" : "arcana_zero_off";
                        break;
                    }
                    case 1: {
                        modelName = active ? "arcana_ignition_on" : "arcana_ignition_off";
                        break;
                    }
                    case 2: {
                        modelName = active ? "arcana_harv_on" : "arcana_harv_off";
                        break;
                    }
                    case 3: {
                        modelName = active ? "arcana_swrg_on" : "arcana_swrg_off";
                        break;
                    }
                    default: {
                        modelName = "";
                    }
                }
                return new ModelResourceLocation("projecte:" + modelName, "inventory");
            }
        });
    }

    @Override
    public void registerRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(AlchChestTile.class, (TileEntitySpecialRenderer)new ChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(CondenserTile.class, (TileEntitySpecialRenderer)new CondenserRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(CondenserMK2Tile.class, (TileEntitySpecialRenderer)new CondenserMK2Renderer());
        Minecraft mc = FMLClientHandler.instance().getClient();
        RenderingRegistry.registerEntityRenderingHandler(EntityWaterProjectile.class, (Render)new RenderSnowball(mc.func_175598_ae(), ObjHandler.waterOrb, mc.func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityLavaProjectile.class, (Render)new RenderSnowball(mc.func_175598_ae(), ObjHandler.lavaOrb, mc.func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityMobRandomizer.class, (Render)new RenderSnowball(mc.func_175598_ae(), ObjHandler.mobRandomizer, mc.func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityLensProjectile.class, (Render)new RenderSnowball(mc.func_175598_ae(), ObjHandler.lensExplosive, mc.func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityLootBall.class, (Render)new RenderSnowball(mc.func_175598_ae(), ObjHandler.lootBall, mc.func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityNovaCatalystPrimed.class, (Render)new NovaCatalystRenderer(mc.func_175598_ae()));
        RenderingRegistry.registerEntityRenderingHandler(EntityNovaCataclysmPrimed.class, (Render)new NovaCataclysmRenderer(mc.func_175598_ae()));
        RenderingRegistry.registerEntityRenderingHandler(EntityFireProjectile.class, (Render)new RenderSnowball(mc.func_175598_ae(), ObjHandler.fireProjectile, mc.func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntitySWRGProjectile.class, (Render)new RenderSnowball(mc.func_175598_ae(), ObjHandler.windProjectile, mc.func_175599_af()));
        try {
            Map<String, RenderPlayer> skinMap = ReflectionHelper.getSkinMap(mc.func_175598_ae());
            RenderPlayer render = skinMap.get("default");
            Method addLayer = net.minecraftforge.fml.relauncher.ReflectionHelper.findMethod(RendererLivingEntity.class, (Object)render, (String[])new String[]{"addLayer", "a", "func_177094_a"}, (Class[])new Class[]{LayerRenderer.class});
            addLayer.invoke((Object)render, new LayerModelYue(render));
            render = skinMap.get("slim");
            addLayer.invoke((Object)render, new LayerModelYue(render));
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            PELogger.logWarn("Reflection failed: ModelYue not available");
        }
    }

    @Override
    public void registerClientOnlyEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new ToolTipEvent());
        MinecraftForge.EVENT_BUS.register((Object)new TransmutationRenderingEvent());
        FMLCommonHandler.instance().bus().register((Object)new KeyPressEvent());
        PlayerRender pr = new PlayerRender();
        MinecraftForge.EVENT_BUS.register((Object)pr);
        FMLCommonHandler.instance().bus().register((Object)pr);
    }

    @Override
    public void initializeManual() {
        ManualPageHandler.init();
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    public boolean isJumpPressed() {
        return FMLClientHandler.instance().getClient().field_71474_y.field_74314_A.func_151470_d();
    }
}

