/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.Main;

import com.LightningCraft.Main.ServerProxy;
import com.LightningCraft.achievements.LCAchievements;
import com.LightningCraft.biomes.LCBiomes;
import com.LightningCraft.blocks.LCBlocks;
import com.LightningCraft.commands.LCCommand;
import com.LightningCraft.config.LCConfig;
import com.LightningCraft.creativetabs.LCCreativeTabs;
import com.LightningCraft.dimensions.LCDimensions;
import com.LightningCraft.enchantments.LCEnchantments;
import com.LightningCraft.entities.LCEntities;
import com.LightningCraft.handler.LCAchievementEvents;
import com.LightningCraft.handler.LCArmorEvents;
import com.LightningCraft.handler.LCEntityEvents;
import com.LightningCraft.handler.LCSwordEvents;
import com.LightningCraft.handler.LCToolEvents;
import com.LightningCraft.hooks.LCChestGenHooks;
import com.LightningCraft.integration.LCModIntegration;
import com.LightningCraft.items.LCItems;
import com.LightningCraft.lib.Log;
import com.LightningCraft.network.LCNetwork;
import com.LightningCraft.potions.LCPotions;
import com.LightningCraft.recipes.LCCraftingManager;
import com.LightningCraft.util.LCText;
import com.LightningCraft.worldgen.structure.LCStructures;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="lightningcraft", name="LightningCraft", version="1.5.0")
public class MainRegistry {
    @SidedProxy(clientSide="com.LightningCraft.Main.ClientProxy", serverSide="com.LightningCraft.Main.ServerProxy")
    public static ServerProxy proxy;
    @Mod.Instance(value="lightningcraft")
    public static MainRegistry modInstance;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent e) {
        Log.logger.info("Initializing LightningCraft...");
        LCText.setupFormatting();
        LCConfig.loadConfig(e.getSuggestedConfigurationFile());
        LCCreativeTabs.mainRegistry();
        LCItems.mainRegistry();
        LCBlocks.mainRegistry();
        LCEntities.mainRegistry();
        LCEnchantments.mainRegistry();
        LCNetwork.mainRegistry();
        LCCraftingManager.mainRegistry();
        LCPotions.mainRegistry();
        LCBiomes.mainRegistry();
        LCDimensions.mainRegistry();
        LCStructures.mainRegistry();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent e) {
        Log.logger.info("Loading LightningCraft...");
        LCCreativeTabs.updateCreativeTabs();
        proxy.registerGuiHandler();
        proxy.registerTileEntities();
        proxy.registerRenderInfo();
        LCAchievements.mainRegistry();
        LCChestGenHooks.mainRegistry();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent e) {
        Log.logger.info("Finalizing LightningCraft...");
        MinecraftForge.EVENT_BUS.register((Object)new LCEntityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new LCToolEvents());
        MinecraftForge.EVENT_BUS.register((Object)new LCSwordEvents());
        MinecraftForge.EVENT_BUS.register((Object)new LCArmorEvents());
        FMLCommonHandler.instance().bus().register((Object)new LCAchievementEvents());
        LCModIntegration.mainRegistry();
    }

    @Mod.EventHandler
    public static void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new LCCommand());
    }
}

