/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.config;

import com.LightningCraft.lib.RefMisc;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class LCConfig {
    public static boolean showAllMetals;
    public static boolean playersCanAddToCannonWL;
    public static String lpName;
    public static String lpNameLong;
    public static int thorEnchID;
    public static int auraEnchID;
    public static int demonFriendPotionID;
    public static int underworldBiomeID;
    public static int underworldDimensionID;
    public static int heavenBiomeID;
    public static int heavenDimensionID;
    public static boolean forceDebug;

    private static void setDefaultValues() {
        showAllMetals = false;
        playersCanAddToCannonWL = true;
        lpNameLong = "Lightning Energy";
        lpName = "LE";
        thorEnchID = 80;
        auraEnchID = 81;
        demonFriendPotionID = 150;
        underworldBiomeID = 212;
        underworldDimensionID = -9;
        heavenBiomeID = 213;
        heavenDimensionID = 9;
        forceDebug = false;
    }

    public static void loadConfig(File f) {
        Configuration config = new Configuration(f);
        LCConfig.setDefaultValues();
        config.load();
        Property p = config.get("General", "showAllMetals", showAllMetals);
        p.comment = "Show all metal types (rods and air terminals) in creative tab / NEI, not just the ones currently loaded in the ore dictionary";
        showAllMetals = p.getBoolean();
        p = config.get("General", "players.canAddThemselvesToCannonWL", playersCanAddToCannonWL);
        p.comment = "Can other players add themselves to existing lightning cannons in the world?";
        playersCanAddToCannonWL = p.getBoolean();
        p = config.get("Enchantments", "handOfThor.ID", thorEnchID);
        p.comment = "The Hand of Thor enchantment ID";
        thorEnchID = p.getInt();
        p = config.get("Enchantments", "elecAura.ID", auraEnchID);
        p.comment = "The Electrostatic Aura enchantment ID";
        auraEnchID = p.getInt();
        p = config.get("Potions", "demonFriend.ID", demonFriendPotionID);
        p.comment = "The Demon Warding potion effect ID";
        demonFriendPotionID = p.getInt();
        p = config.get("Worldgen", "biomes.underworld.ID", underworldBiomeID);
        p.comment = "The Underworld biome ID";
        underworldBiomeID = p.getInt();
        p = config.get("Worldgen", "dimensions.underworld.ID", underworldDimensionID);
        p.comment = "The Underworld dimension ID";
        underworldDimensionID = p.getInt();
        p = config.get("Worldgen", "biomes.heaven.ID", heavenBiomeID);
        p.comment = "The Arcadia biome ID";
        heavenBiomeID = p.getInt();
        p = config.get("Worldgen", "dimensions.heaven.ID", heavenDimensionID);
        p.comment = "The Arcadia dimension ID";
        heavenDimensionID = p.getInt();
        p = config.get("Debug", "forcedebug", forceDebug);
        p.comment = "Warning: Forcing debug mode will slow your game down in certain situations. Only do this when you need to trace a bug!";
        forceDebug = p.getBoolean();
        if (forceDebug) {
            RefMisc.DEBUG = true;
            System.out.println("Config: Debug mode has been forced. Expect slower performance occasionally.");
        }
        config.save();
    }
}

