/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.items;

import com.LightningCraft.config.LCConfig;
import com.LightningCraft.items.ItemMetaWithRarities;
import com.LightningCraft.items.ifaces.IInventoryLPUser;
import com.LightningCraft.util.LCText;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class LPBattery
extends ItemMetaWithRarities {
    public static final int nIcons = 8;
    public static final int nGrades = 3;

    public LPBattery() {
        super(24, "lp_battery_", new EnumRarity[]{IInventoryLPUser.ILPRarity});
        this.func_77625_d(1);
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 3; ++i) {
            ItemStack empty = new ItemStack(item, 1, i);
            ItemStack charged = new ItemStack(item, 1, i);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("StoredPower", LPBattery.getMaxPower(charged));
            charged.func_77982_d(tag);
            list.add(empty);
            list.add(charged);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (stack.field_77994_a < 1) {
            stack = null;
        }
    }

    public static double getStoredPower(ItemStack stack) {
        return stack == null || !stack.func_77942_o() ? 0.0 : stack.func_77978_p().func_74769_h("StoredPower");
    }

    public static boolean setStoredPower(ItemStack stack, double power) {
        if (stack != null) {
            if (!stack.func_77942_o()) {
                stack.field_77990_d = new NBTTagCompound();
            }
            stack.func_77978_p().func_74780_a("StoredPower", power);
            return true;
        }
        return false;
    }

    public static boolean addStoredPower(ItemStack stack, double add) {
        return LPBattery.setStoredPower(stack, LPBattery.getStoredPower(stack) + add);
    }

    public static double getMaxPower(ItemStack stack) {
        return 16.0 * ((double)stack.func_77960_j() + 1.0);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        double power = LPBattery.getStoredPower(stack);
        double maxpower = LPBattery.getMaxPower(stack);
        int charge = (int)(100.0 * (power / maxpower));
        list.add("Stored Power: " + LCText.df.format(power) + "/" + LCText.df.format(maxpower) + " " + LCConfig.lpName + " (" + charge + "%)");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        int displayPower = (int)Math.round(LPBattery.getStoredPower(stack) / (LPBattery.getMaxPower(stack) / (double)(this.nSubtypes / 3 - 1)));
        displayPower = Math.min(Math.min(displayPower, this.nSubtypes / 3 - 1) + stack.func_77960_j() * 8, 23);
        return this.icons[displayPower];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }
}

