/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.tileentities;

import com.LightningCraft.config.LCConfig;
import com.LightningCraft.tileentities.TileEntityLPTransmitter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;

public class TileEntityLPReceiver
extends TileEntity {
    public TileEntityLPTransmitter tx;
    public Vec3 txPos = Vec3.func_72443_a((double)0.0, (double)-2.0, (double)0.0);
    public double rolloff;
    public double efficiency;
    public double storedPower;
    public double maxPower;
    public boolean outOfRange;

    public TileEntityLPReceiver(double rolloff) {
        this.rolloff = rolloff;
    }

    public TileEntityLPReceiver() {
        this(0.0);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity tile;
            int txX = (int)this.txPos.field_72450_a;
            int txY = (int)this.txPos.field_72448_b;
            int txZ = (int)this.txPos.field_72449_c;
            boolean hasTx = true;
            this.outOfRange = false;
            if (txY >= 0 && (tile = this.field_145850_b.func_147438_o(txX, txY, txZ)) != null && tile instanceof TileEntityLPTransmitter) {
                this.tx = (TileEntityLPTransmitter)tile;
                double distanceSq = this.tx.func_145835_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (distanceSq <= this.tx.range * this.tx.range) {
                    if (this.tx.hasLPCell()) {
                        this.storedPower = this.tx.cellPower;
                        this.maxPower = this.tx.maxPower;
                        this.efficiency = this.tx.quality - distanceSq * this.rolloff;
                    } else {
                        hasTx = false;
                    }
                } else {
                    hasTx = false;
                    this.outOfRange = true;
                }
            } else {
                hasTx = false;
            }
            if (!hasTx) {
                this.storedPower = 0.0;
                this.maxPower = -1.0;
                this.efficiency = -1.0;
            }
        }
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.txPos.field_72450_a = tagCompound.func_74769_h("TransmitterX");
        this.txPos.field_72448_b = tagCompound.func_74769_h("TransmitterY");
        this.txPos.field_72449_c = tagCompound.func_74769_h("TransmitterZ");
        this.storedPower = tagCompound.func_74769_h("StoredPower");
        this.maxPower = tagCompound.func_74769_h("MaxPower");
        this.rolloff = tagCompound.func_74769_h("Rolloff");
        this.efficiency = tagCompound.func_74769_h("Efficiency");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74780_a("TransmitterX", this.txPos.field_72450_a);
        tagCompound.func_74780_a("TransmitterY", this.txPos.field_72448_b);
        tagCompound.func_74780_a("TransmitterZ", this.txPos.field_72449_c);
        tagCompound.func_74780_a("StoredPower", this.storedPower);
        tagCompound.func_74780_a("MaxPower", this.maxPower);
        tagCompound.func_74780_a("Rolloff", this.rolloff);
        tagCompound.func_74780_a("Efficiency", this.efficiency);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public String getInventoryName() {
        return LCConfig.lpName + " Receiver";
    }
}

