/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.tileentities;

import com.LightningCraft.achievements.LCAchievements;
import com.LightningCraft.blocks.LCBlocks;
import com.LightningCraft.entities.EntityLCLightningBolt;
import com.LightningCraft.util.WeatherUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityLightningCell
extends TileEntity {
    public double storedPower;
    public double maxPower;
    public double efficiency;
    public int cooldownTime;
    public boolean isUpgraded;
    public String cellName;
    private Random random = new Random();
    private boolean topTierTerminal = false;
    private boolean aCheck = false;

    public TileEntityLightningCell(short mp, String name) {
        this.maxPower = mp;
        this.cellName = name;
    }

    public TileEntityLightningCell() {
    }

    public void func_145845_h() {
        EntityPlayer player;
        boolean dosave = false;
        if (this.field_145850_b.field_72995_K) {
            this.isAirTerminalPresent();
            return;
        }
        if (this.storedPower > this.maxPower) {
            this.storedPower = this.maxPower;
        }
        if (this.storedPower < 0.0) {
            this.storedPower = 0.0;
        }
        if (!this.aCheck && this.maxPower == 4000.0 && this.topTierTerminal && (player = this.field_145850_b.func_72977_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 16.0)) != null) {
            player.func_71064_a((StatBase)LCAchievements.perfectCell, 1);
            this.aCheck = true;
        }
        if (this.cooldownTime > 0) {
            --this.cooldownTime;
            dosave = true;
        }
        if (this.isAirTerminalPresent()) {
            AxisAlignedBB box;
            List<EntityLightningBolt> bolts;
            double chance = 1.0E-6;
            if (this.field_145850_b.func_72911_I()) {
                chance = 2.0E-5;
            }
            if (this.random.nextDouble() <= chance) {
                EntityLCLightningBolt lightning = new EntityLCLightningBolt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, false);
                lightning.func_70107_b(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                this.field_145850_b.func_72942_c((Entity)lightning);
            }
            if (!(bolts = WeatherUtils.getLightningBoltsWithinAABB(this.field_145850_b, box = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 5), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - 5), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 5)))).isEmpty() && this.cooldownTime <= 0 && this.storedPower < this.maxPower) {
                for (EntityLightningBolt bolt : bolts) {
                    if (bolt.field_70128_L) {
                        return;
                    }
                    this.field_145850_b.func_72900_e((Entity)bolt);
                }
                this.storedPower += 64.0 * this.efficiency;
                this.cooldownTime = 100;
                dosave = true;
            }
        }
        if (dosave) {
            this.func_70296_d();
        }
    }

    public void func_145841_b(NBTTagCompound par1) {
        super.func_145841_b(par1);
        par1.func_74780_a("storedPower", this.storedPower);
        par1.func_74780_a("maxPower", this.maxPower);
        par1.func_74768_a("cooldownTime", this.cooldownTime);
        par1.func_74757_a("isUpgraded", this.isUpgraded);
        par1.func_74778_a("customName", this.cellName);
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.storedPower = par1.func_74769_h("storedPower");
        this.maxPower = par1.func_74769_h("maxPower");
        this.cooldownTime = par1.func_74762_e("cooldownTime");
        this.isUpgraded = par1.func_74767_n("isUpgraded");
        this.cellName = par1.func_74779_i("customName");
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean isAirTerminalPresent() {
        boolean flag;
        this.topTierTerminal = false;
        Block test = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (test == LCBlocks.airTerm) {
            flag = true;
            switch (meta) {
                case 0: {
                    this.efficiency = 0.45;
                    break;
                }
                case 1: {
                    this.efficiency = 0.5;
                    break;
                }
                case 2: {
                    this.efficiency = 0.52;
                    break;
                }
                case 3: {
                    this.efficiency = 0.55;
                    break;
                }
                case 4: {
                    this.efficiency = 0.65;
                    break;
                }
                case 5: {
                    this.efficiency = 0.7;
                    break;
                }
                case 6: {
                    this.efficiency = 0.9;
                    break;
                }
                case 7: {
                    this.efficiency = 1.05;
                    this.topTierTerminal = true;
                    break;
                }
                default: {
                    this.efficiency = 0.5;
                    break;
                }
            }
        } else {
            flag = false;
            this.efficiency = 0.0;
        }
        return flag;
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.cellName : "Lightning Cell";
    }

    public boolean hasCustomInventoryName() {
        return this.cellName != null && this.cellName.length() > 0;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }
}

