/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.tileentities;

import com.LightningCraft.entities.EntityLCElectricAttack;
import com.LightningCraft.tileentities.TileEntityLPUser;
import com.LightningCraft.util.WLRequest;
import com.LightningCraft.util.WorldUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;

public class TileEntityUnderworldCannon
extends TileEntityLPUser
implements WLRequest.WLUser {
    public static final Random rand = new Random();
    public static final int maxIdleTicks = 400;
    public static final int minIdleTicks = 40;
    public static final double lpPerAttack = 5.0;
    public int ticksUntilNextAttack;
    public int currentTicks = 0;
    public double tileX;
    public double tileY;
    public double tileZ;
    public LinkedList<UUID> playerWhitelist;
    public LinkedList<String> playerWhitelistStr;
    public boolean isLocked = false;
    public EnumMode operatingMode;
    public Integer[] modeRotation = new Integer[]{0, 1, 2, 3, 10};
    public int modeRotationIndex;

    public TileEntityUnderworldCannon() {
        this.ticksUntilNextAttack = this.reload();
        this.playerWhitelist = new LinkedList();
        this.playerWhitelistStr = new LinkedList();
        this.operatingMode = EnumMode.DEFAULT;
        this.modeRotationIndex = Arrays.binarySearch((Object[])this.modeRotation, (Object)this.operatingMode.getID());
    }

    @Override
    public Vec3 getPosition() {
        return Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }

    private int reload() {
        return rand.nextInt(360) + 40;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tileX = (double)this.field_145851_c + 0.5;
            this.tileY = (double)this.field_145848_d + 0.5;
            this.tileZ = (double)this.field_145849_e + 0.5;
            EntityPlayer target = null;
            boolean doAttack = false;
            boolean drawPower = false;
            if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 0) {
                ++this.currentTicks;
                if (this.currentTicks > this.ticksUntilNextAttack) {
                    target = WorldUtils.getClosestVulnerablePlayer(this.field_145850_b, this.tileX, this.tileY, this.tileZ, 32.0, new LinkedList<UUID>());
                    doAttack = true;
                }
            } else {
                this.currentTicks = this.hasLPCell() && this.canDrawCellPower(5.0) ? ++this.currentTicks : 0;
                if (this.currentTicks > this.ticksUntilNextAttack) {
                    switch (this.operatingMode) {
                        case NONE: {
                            target = null;
                            break;
                        }
                        case PLAYERS_ONLY: {
                            target = WorldUtils.getClosestVulnerablePlayer(this.field_145850_b, this.tileX, this.tileY, this.tileZ, 32.0, this.playerWhitelist);
                            break;
                        }
                        case MOBS_ONLY: {
                            target = (EntityLivingBase)WorldUtils.getClosestVulnerableEntityOfType(this.field_145850_b, this.tileX, this.tileY, this.tileZ, 32.0, IMob.class, new Class[0]);
                            break;
                        }
                        case PLAYERS_MOBS: {
                            target = (EntityLivingBase)WorldUtils.getClosestVulnerableEntityOfType(this.field_145850_b, this.tileX, this.tileY, this.tileZ, 32.0, IMob.class, new Class[0]);
                            if (target != null) break;
                            target = WorldUtils.getClosestVulnerablePlayer(this.field_145850_b, this.tileX, this.tileY, this.tileZ, 32.0, this.playerWhitelist);
                            break;
                        }
                        case ALL: {
                            target = (EntityLivingBase)WorldUtils.getClosestVulnerableEntityOfType(this.field_145850_b, this.tileX, this.tileY, this.tileZ, 32.0, EntityLivingBase.class, EntityPlayer.class);
                            if (target != null) break;
                            target = WorldUtils.getClosestVulnerablePlayer(this.field_145850_b, this.tileX, this.tileY, this.tileZ, 32.0, this.playerWhitelist);
                            break;
                        }
                        default: {
                            target = null;
                        }
                    }
                    doAttack = true;
                    drawPower = true;
                }
            }
            if (doAttack) {
                if (target != null && this.canEntityBeSeen((Entity)target)) {
                    EntityLCElectricAttack bolt = new EntityLCElectricAttack(this.field_145850_b, this.tileX, this.tileY, this.tileZ, (Entity)target);
                    this.field_145850_b.func_72838_d((Entity)bolt);
                    this.field_145850_b.func_72956_a((Entity)bolt, "fireworks.blast", 3.0f, 0.1f);
                    if (drawPower) {
                        this.drawCellPower(5.0);
                    }
                }
                this.ticksUntilNextAttack = this.reload();
                this.currentTicks = 0;
            }
        }
    }

    @Override
    public boolean pendPlayerToWhitelist(EntityPlayer p) {
        if (this.playerWhitelist.isEmpty()) {
            p.func_145747_a((IChatComponent)new WLRequest.WLChatText("Error: this cannon does not have an owner!"));
            return false;
        }
        UUID owner = this.playerWhitelist.get(0);
        UUID requester = p.func_110124_au();
        EntityPlayer ownerEntity = WorldUtils.getEntityPlayerFromUUID(this.field_145850_b, owner);
        if (!this.playerWhitelist.contains(requester)) {
            if (ownerEntity != null) {
                WLRequest.requestQueue.addLast(new WLRequest(requester, owner, this));
                ownerEntity.func_145747_a((IChatComponent)new WLRequest.WLChatText(p.getDisplayName() + " has sent you a whitelist request to your cannon located at (" + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + "). " + "Type '/" + "lightningcraft" + "wl-accept' to accept, or '/" + "lightningcraft" + "wl-deny' to deny."));
                p.func_145747_a((IChatComponent)new WLRequest.WLChatText("Your whitelist request has been sent to the cannon owner."));
                return true;
            }
            p.func_145747_a((IChatComponent)new WLRequest.WLChatText("The cannon owner is currently offline. Try again later."));
            return false;
        }
        p.func_145747_a((IChatComponent)new WLRequest.WLChatText("You are already whitelisted!"));
        return false;
    }

    @Override
    public boolean addPlayerToWhitelist(EntityPlayer p) {
        UUID add = p.func_110124_au();
        if (!this.playerWhitelist.contains(add)) {
            this.playerWhitelist.add(add);
            this.playerWhitelistStr.add(p.getDisplayName());
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean rotateOperatingMode(EntityPlayer p) {
        UUID add = p.func_110124_au();
        if (this.playerWhitelist.contains(add)) {
            this.modeRotationIndex = Arrays.binarySearch((Object[])this.modeRotation, (Object)this.operatingMode.getID()) + 1;
            if (this.modeRotationIndex >= this.modeRotation.length) {
                this.modeRotationIndex = 0;
            }
            this.operatingMode = EnumMode.assignMode(this.modeRotation[this.modeRotationIndex]);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean canEntityBeSeen(Entity e) {
        return this.field_145850_b.func_72933_a(Vec3.func_72443_a((double)(this.tileX + 1.0), (double)this.tileY, (double)(this.tileZ + 0.0)), Vec3.func_72443_a((double)e.field_70165_t, (double)(e.field_70163_u + (double)e.func_70047_e()), (double)e.field_70161_v)) == null || this.field_145850_b.func_72933_a(Vec3.func_72443_a((double)(this.tileX + 0.0), (double)this.tileY, (double)(this.tileZ + 1.0)), Vec3.func_72443_a((double)e.field_70165_t, (double)(e.field_70163_u + (double)e.func_70047_e()), (double)e.field_70161_v)) == null || this.field_145850_b.func_72933_a(Vec3.func_72443_a((double)(this.tileX - 1.0), (double)this.tileY, (double)(this.tileZ + 0.0)), Vec3.func_72443_a((double)e.field_70165_t, (double)(e.field_70163_u + (double)e.func_70047_e()), (double)e.field_70161_v)) == null || this.field_145850_b.func_72933_a(Vec3.func_72443_a((double)(this.tileX + 0.0), (double)this.tileY, (double)(this.tileZ - 1.0)), Vec3.func_72443_a((double)e.field_70165_t, (double)(e.field_70163_u + (double)e.func_70047_e()), (double)e.field_70161_v)) == null;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this || this.func_145832_p() == 0 ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public String getInventoryName() {
        return this.func_145838_q().func_149732_F();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.playerWhitelist = new LinkedList();
        this.playerWhitelistStr = new LinkedList();
        this.ticksUntilNextAttack = tagCompound.func_74762_e("ticksUntilNextAttack");
        this.currentTicks = tagCompound.func_74762_e("currentTicks");
        this.operatingMode = EnumMode.assignMode(tagCompound.func_74762_e("operatingMode"));
        int size = tagCompound.func_74762_e("WhitelistCount");
        for (int n = 0; n < size; ++n) {
            this.playerWhitelist.add(UUID.fromString(tagCompound.func_74779_i("WL" + n)));
            this.playerWhitelistStr.add(tagCompound.func_74779_i("WL" + n + "_str"));
        }
        this.modeRotationIndex = Arrays.binarySearch((Object[])this.modeRotation, (Object)this.operatingMode.getID());
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("ticksUntilNextAttack", this.ticksUntilNextAttack);
        tagCompound.func_74768_a("currentTicks", this.currentTicks);
        tagCompound.func_74768_a("operatingMode", this.operatingMode.id);
        NBTTagList whiteList = new NBTTagList();
        tagCompound.func_74768_a("WhitelistCount", this.playerWhitelist.size());
        for (int n = 0; n < this.playerWhitelist.size(); ++n) {
            tagCompound.func_74778_a("WL" + n, this.playerWhitelist.get(n).toString());
            tagCompound.func_74778_a("WL" + n + "_str", this.playerWhitelistStr.get(n));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public static enum EnumMode {
        NONE(0, "None"),
        PLAYERS_ONLY(1, "Players Only"),
        MOBS_ONLY(2, "Hostile Mobs Only"),
        PLAYERS_MOBS(3, "Players & Hostiles"),
        ALL(10, "All Entities");

        private static EnumMode DEFAULT;
        private int id;
        private String name;

        private EnumMode(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getID() {
            return this.id;
        }

        public static EnumMode assignMode(int id) {
            for (EnumMode m : EnumMode.values()) {
                if (m.id != id) continue;
                return m;
            }
            return DEFAULT;
        }

        static {
            DEFAULT = NONE;
        }
    }
}

