/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.worldgen.structure;

import com.LightningCraft.lib.RefMisc;
import com.LightningCraft.worldgen.structure.LootChestGroup;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public abstract class Feature
extends StructureComponent {
    protected LootChestGroup lootChests;
    protected int scatteredFeatureSizeX;
    protected int scatteredFeatureSizeY;
    protected int scatteredFeatureSizeZ;
    protected int structY = -1;
    protected int spawnMinY;
    protected int spawnMaxY;

    public Feature() {
    }

    protected Feature(Random rand, int x, int y, int z, int sx, int sy, int sz, boolean useRandomCoordBaseMode) {
        super(0);
        this.scatteredFeatureSizeX = sx;
        this.scatteredFeatureSizeY = sy;
        this.scatteredFeatureSizeZ = sz;
        this.field_74885_f = useRandomCoordBaseMode ? rand.nextInt(4) : 0;
        switch (this.field_74885_f) {
            case 0: 
            case 2: {
                this.field_74887_e = new StructureBoundingBox(x, y, z, x + sx - 1, y + sy - 1, z + sz - 1);
                break;
            }
            default: {
                this.field_74887_e = new StructureBoundingBox(x, y, z, x + sz - 1, y + sy - 1, z + sx - 1);
            }
        }
    }

    protected Feature(Random rand, int x, int y, int z, int sx, int sy, int sz) {
        this(rand, x, y, z, sx, sy, sz, true);
    }

    protected void func_143012_a(NBTTagCompound tag) {
        tag.func_74768_a("Width", this.scatteredFeatureSizeX);
        tag.func_74768_a("Height", this.scatteredFeatureSizeY);
        tag.func_74768_a("Depth", this.scatteredFeatureSizeZ);
        tag.func_74768_a("HPos", this.structY);
        this.lootChests.writeToNBT(tag);
    }

    protected void func_143011_b(NBTTagCompound tag) {
        this.scatteredFeatureSizeX = tag.func_74762_e("Width");
        this.scatteredFeatureSizeY = tag.func_74762_e("Height");
        this.scatteredFeatureSizeZ = tag.func_74762_e("Depth");
        this.structY = tag.func_74762_e("HPos");
        this.lootChests.readFromNBT(tag);
    }

    protected boolean generateStructureChestContents(World world, StructureBoundingBox box, Random rand, int x, int y, int z, int meta, int chestIndex) {
        return this.generateStructureChestContents(world, box, rand, x, y, z, meta, this.lootChests.getChestContents(chestIndex), this.lootChests.getStackCount(rand, chestIndex), this.lootChests.getIsTrapped(chestIndex));
    }

    protected boolean generateStructureChestContents(World world, StructureBoundingBox box, Random rand, int x, int y, int z, int meta) {
        return this.generateStructureChestContents(world, box, rand, x, y, z, meta, this.lootChests.getChestContents(), this.lootChests.getStackCount(rand), false);
    }

    protected boolean generateStructureChestContents(World world, StructureBoundingBox box, Random rand, int x, int y, int z, int meta, WeightedRandomChestContent[] chest, int count, boolean isTrapped) {
        int i1 = this.func_74865_a(x, z);
        int j1 = this.func_74862_a(y);
        int k1 = this.func_74873_b(x, z);
        Object chestBlock = isTrapped ? Blocks.field_150447_bR : Blocks.field_150486_ae;
        if (world.func_147439_a(i1, j1, k1) != chestBlock) {
            world.func_147465_d(i1, j1, k1, chestBlock, meta, 2);
            world.func_72921_c(i1, j1, k1, meta, 2);
            TileEntityChest tileentitychest = (TileEntityChest)world.func_147438_o(i1, j1, k1);
            if (tileentitychest != null) {
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])chest, (IInventory)tileentitychest, (int)count);
            }
            if (RefMisc.DEBUG) {
                System.out.println("Chest generated at (" + i1 + ", " + j1 + ", " + k1 + ") with metadata " + meta);
            }
            return true;
        }
        if (RefMisc.DEBUG) {
            System.out.println("Chest NOT generated at (" + i1 + ", " + j1 + ", " + k1 + ")");
        }
        return false;
    }

    protected boolean generateStructureChestContents(World world, StructureBoundingBox box, Random rand, int x, int y, int z, int meta, WeightedRandomChestContent[] chest, int count) {
        return this.generateStructureChestContents(world, box, rand, x, y, z, meta, chest, count, false);
    }

    protected void addBlock(World world, int x, int y, int z, Block block, int meta) {
        boolean ignoreBox = false;
        if (meta < 0) {
            meta = 0;
            ignoreBox = true;
        }
        this.placeBlockAtCurrentPosition(world, block, meta, x, y, z, this.field_74887_e, ignoreBox);
    }

    protected void addBlock(World world, int x, int y, int z, int block, int meta) {
        this.func_151550_a(world, Block.func_149729_e((int)block), meta, x, y, z, this.field_74887_e);
    }

    protected void placeBlockAtCurrentPosition(World world, Block b, int meta, int x, int y, int z, StructureBoundingBox box, boolean ignoreBox) {
        int k1;
        int j1;
        int i1 = this.func_74865_a(x, z);
        if (box.func_78890_b(i1, j1 = this.func_74862_a(y), k1 = this.func_74873_b(x, z)) || ignoreBox) {
            world.func_147465_d(i1, j1, k1, b, meta, 2);
        }
    }

    protected abstract boolean findSpawnPosition(World var1, StructureBoundingBox var2, int var3);
}

