/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.worldgen.structure.arcadia;

import com.LightningCraft.blocks.LCBlocks;
import com.LightningCraft.items.LCItems;
import com.LightningCraft.util.WorldUtils;
import com.LightningCraft.worldgen.structure.Feature;
import com.LightningCraft.worldgen.structure.LootChestGroup;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class HeavenKeep
extends Feature {
    private static final int nChests = 4;
    private static final int minStacks = 2;
    private static final int maxStacks = 5;
    private static final Block mainBlock = Blocks.field_150417_aV;
    private static final int mainMeta = 0;
    private static final Block secondBlock = LCBlocks.heavenstone;
    private static final Block accentBlock = LCBlocks.heavenstoneBricks;
    private static final int accentMeta = 1;
    private static final Block wallBlock = Blocks.field_150463_bK;
    private static final Block windowBlock = Blocks.field_150411_aY;

    public HeavenKeep() {
        this(new Random(), 0, 0);
    }

    public HeavenKeep(Random rand, int x, int z) {
        super(rand, x, 64, z, 8, 11, 8, false);
        this.spawnMinY = 10;
        this.spawnMaxY = 80;
        this.lootChests = new LootChestGroup(4, 2, 5, new WeightedRandomChestContent[]{new WeightedRandomChestContent(new ItemStack(LCBlocks.metalBlock, 1, 1), 1, 3, 8), new WeightedRandomChestContent(new ItemStack(Blocks.field_150368_y), 3, 8, 10), new WeightedRandomChestContent(LCItems.cannonCore, 0, 1, 2, 4), new WeightedRandomChestContent(LCItems.skySword, 0, 1, 1, 3), new WeightedRandomChestContent(LCItems.skyBoots, 0, 1, 1, 3), new WeightedRandomChestContent(LCItems.skyHelm, 0, 1, 1, 3), new WeightedRandomChestContent(LCItems.skyChest, 0, 1, 1, 2), new WeightedRandomChestContent(LCItems.skyLegs, 0, 1, 1, 3), new WeightedRandomChestContent(LCItems.skyAxe, 0, 1, 1, 5), new WeightedRandomChestContent(LCItems.skyPick, 0, 1, 1, 5)});
    }

    @Override
    protected boolean findSpawnPosition(World world, StructureBoundingBox box, int yoff) {
        if (this.structY >= 0) {
            return true;
        }
        for (int y = this.spawnMinY; y <= this.spawnMaxY; ++y) {
            if (!WorldUtils.canSpawnAtPositionLoosely(world, this.field_74887_e.field_78897_a, y, this.field_74887_e.field_78896_c, this.scatteredFeatureSizeY, 1, 0) || !WorldUtils.canSpawnAtPositionLoosely(world, this.field_74887_e.field_78893_d, y, this.field_74887_e.field_78896_c, this.scatteredFeatureSizeY, 1, 0) || !WorldUtils.canSpawnAtPositionLoosely(world, this.field_74887_e.field_78897_a, y, this.field_74887_e.field_78892_f, this.scatteredFeatureSizeY, 1, 0) || !WorldUtils.canSpawnAtPositionLoosely(world, this.field_74887_e.field_78893_d, y, this.field_74887_e.field_78892_f, this.scatteredFeatureSizeY, 1, 0)) continue;
            this.structY = y - 1;
            this.field_74887_e.func_78886_a(0, this.structY - this.field_74887_e.field_78895_b + yoff, 0);
            return true;
        }
        return false;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
        if (!this.findSpawnPosition(world, box, 0)) {
            return false;
        }
        this.addBlock(world, 0, 0, 1, accentBlock, 1);
        this.addBlock(world, 0, 0, 2, mainBlock, 0, rand);
        this.addBlock(world, 0, 0, 3, mainBlock, 0, rand);
        this.addBlock(world, 0, 0, 4, mainBlock, 0, rand);
        this.addBlock(world, 0, 0, 5, mainBlock, 0, rand);
        this.addBlock(world, 0, 0, 6, accentBlock, 1);
        this.addBlock(world, 0, 1, 2, mainBlock, 0, rand);
        this.addBlock(world, 0, 1, 5, mainBlock, 0, rand);
        this.addBlock(world, 0, 2, 2, mainBlock, 0, rand);
        this.addBlock(world, 0, 2, 5, mainBlock, 0, rand);
        this.addBlock(world, 0, 3, 2, mainBlock, 0, rand);
        this.addBlock(world, 0, 3, 5, mainBlock, 0, rand);
        this.addBlock(world, 0, 4, 1, accentBlock, 1);
        this.addBlock(world, 0, 4, 2, mainBlock, 0, rand);
        this.addBlock(world, 0, 4, 3, mainBlock, 0, rand);
        this.addBlock(world, 0, 4, 4, mainBlock, 0, rand);
        this.addBlock(world, 0, 4, 5, mainBlock, 0, rand);
        this.addBlock(world, 0, 4, 6, accentBlock, 1);
        this.addBlock(world, 1, 0, 0, accentBlock, 1);
        this.addBlock(world, 1, 0, 1, mainBlock, 0, rand);
        this.addBlock(world, 1, 0, 2, mainBlock, 0, rand);
        this.addBlock(world, 1, 0, 3, mainBlock, 0, rand);
        this.addBlock(world, 1, 0, 4, mainBlock, 0, rand);
        this.addBlock(world, 1, 0, 5, mainBlock, 0, rand);
        this.addBlock(world, 1, 0, 6, mainBlock, 0, rand);
        this.addBlock(world, 1, 0, 7, accentBlock, 1);
        this.addBlock(world, 1, 1, 1, mainBlock, 0, rand);
        this.addBlock(world, 1, 1, 6, mainBlock, 0, rand);
        this.addBlock(world, 1, 2, 1, wallBlock, 0);
        this.addBlock(world, 1, 2, 6, wallBlock, 0);
        this.addBlock(world, 1, 3, 1, wallBlock, 0);
        this.addBlock(world, 1, 3, 6, wallBlock, 0);
        this.addBlock(world, 1, 4, 0, accentBlock, 1);
        this.addBlock(world, 1, 4, 1, wallBlock, 0);
        this.addBlock(world, 1, 4, 2, secondBlock, 0);
        this.addBlock(world, 1, 4, 3, secondBlock, 0);
        this.addBlock(world, 1, 4, 4, secondBlock, 0);
        this.addBlock(world, 1, 4, 5, secondBlock, 0);
        this.addBlock(world, 1, 4, 6, wallBlock, 0);
        this.addBlock(world, 1, 4, 7, accentBlock, 1);
        this.addBlock(world, 1, 5, 1, wallBlock, 0);
        this.addBlock(world, 1, 5, 2, mainBlock, 0, rand);
        this.addBlock(world, 1, 5, 3, mainBlock, 0, rand);
        this.addBlock(world, 1, 5, 4, mainBlock, 0, rand);
        this.addBlock(world, 1, 5, 5, mainBlock, 0, rand);
        this.addBlock(world, 1, 5, 6, wallBlock, 0);
        this.addBlock(world, 1, 6, 1, wallBlock, 0);
        this.addBlock(world, 1, 6, 2, mainBlock, 0, rand);
        this.addBlock(world, 1, 6, 3, mainBlock, 0, rand);
        this.addBlock(world, 1, 6, 4, mainBlock, 0, rand);
        this.addBlock(world, 1, 6, 5, mainBlock, 0, rand);
        this.addBlock(world, 1, 6, 6, wallBlock, 0);
        this.addBlock(world, 1, 7, 1, wallBlock, 0);
        this.addBlock(world, 1, 7, 2, mainBlock, 0, rand);
        this.addBlock(world, 1, 7, 3, windowBlock, 0);
        this.addBlock(world, 1, 7, 4, windowBlock, 0);
        this.addBlock(world, 1, 7, 5, mainBlock, 0, rand);
        this.addBlock(world, 1, 7, 6, wallBlock, 0);
        this.addBlock(world, 1, 8, 1, wallBlock, 0);
        this.addBlock(world, 1, 8, 2, mainBlock, 0, rand);
        this.addBlock(world, 1, 8, 3, mainBlock, 0, rand);
        this.addBlock(world, 1, 8, 4, mainBlock, 0, rand);
        this.addBlock(world, 1, 8, 5, mainBlock, 0, rand);
        this.addBlock(world, 1, 8, 6, wallBlock, 0);
        this.addBlock(world, 1, 9, 1, wallBlock, 0);
        this.addBlock(world, 1, 9, 6, wallBlock, 0);
        this.addBlock(world, 1, 10, 1, wallBlock, 0);
        this.addBlock(world, 1, 10, 6, wallBlock, 0);
        this.addBlock(world, 2, 0, 0, mainBlock, 0, rand);
        this.addBlock(world, 2, 0, 1, mainBlock, 0, rand);
        this.addBlock(world, 2, 0, 2, mainBlock, 0, rand);
        this.addBlock(world, 2, 0, 3, mainBlock, 0, rand);
        this.addBlock(world, 2, 0, 4, mainBlock, 0, rand);
        this.addBlock(world, 2, 0, 5, mainBlock, 0, rand);
        this.addBlock(world, 2, 0, 6, mainBlock, 0, rand);
        this.addBlock(world, 2, 0, 7, mainBlock, 0, rand);
        this.addBlock(world, 2, 1, 0, mainBlock, 0, rand);
        this.addBlock(world, 2, 1, 7, mainBlock, 0, rand);
        this.addBlock(world, 2, 2, 0, mainBlock, 0, rand);
        this.addBlock(world, 2, 2, 7, mainBlock, 0, rand);
        this.addBlock(world, 2, 3, 0, mainBlock, 0, rand);
        this.addBlock(world, 2, 3, 7, mainBlock, 0, rand);
        this.addBlock(world, 2, 4, 0, mainBlock, 0, rand);
        this.addBlock(world, 2, 4, 1, secondBlock, 0);
        this.addBlock(world, 2, 4, 2, secondBlock, 0);
        this.addBlock(world, 2, 4, 3, secondBlock, 0);
        this.addBlock(world, 2, 4, 4, secondBlock, 0);
        this.addBlock(world, 2, 4, 5, secondBlock, 0);
        this.addBlock(world, 2, 4, 6, secondBlock, 0);
        this.addBlock(world, 2, 4, 7, mainBlock, 0, rand);
        this.addBlock(world, 2, 5, 1, mainBlock, 0, rand);
        this.addBlock(world, 2, 5, 6, mainBlock, 0, rand);
        this.addBlock(world, 2, 6, 1, mainBlock, 0, rand);
        this.addBlock(world, 2, 6, 6, mainBlock, 0, rand);
        this.addBlock(world, 2, 7, 1, mainBlock, 0, rand);
        this.addBlock(world, 2, 7, 6, mainBlock, 0, rand);
        this.addBlock(world, 2, 8, 1, mainBlock, 0, rand);
        this.addBlock(world, 2, 8, 6, mainBlock, 0, rand);
        this.addBlock(world, 2, 9, 2, mainBlock, 0, rand);
        this.addBlock(world, 2, 9, 3, mainBlock, 0, rand);
        this.addBlock(world, 2, 9, 4, mainBlock, 0, rand);
        this.addBlock(world, 2, 9, 5, mainBlock, 0, rand);
        this.addBlock(world, 3, 0, 0, mainBlock, 0, rand);
        this.addBlock(world, 3, 0, 1, mainBlock, 0, rand);
        this.addBlock(world, 3, 0, 2, mainBlock, 0, rand);
        this.addBlock(world, 3, 0, 3, secondBlock, 0);
        this.addBlock(world, 3, 0, 4, secondBlock, 0);
        this.addBlock(world, 3, 0, 5, mainBlock, 0, rand);
        this.addBlock(world, 3, 0, 6, mainBlock, 0, rand);
        this.addBlock(world, 3, 0, 7, mainBlock, 0, rand);
        this.addBlock(world, 3, 4, 0, mainBlock, 0, rand);
        this.addBlock(world, 3, 4, 1, secondBlock, 0);
        this.addBlock(world, 3, 4, 2, secondBlock, 0);
        this.addBlock(world, 3, 4, 3, secondBlock, 0);
        this.addBlock(world, 3, 4, 4, secondBlock, 0);
        this.addBlock(world, 3, 4, 5, secondBlock, 0);
        this.addBlock(world, 3, 4, 6, secondBlock, 0);
        this.addBlock(world, 3, 4, 7, mainBlock, 0, rand);
        this.addBlock(world, 3, 5, 1, mainBlock, 0, rand);
        this.addBlock(world, 3, 5, 6, mainBlock, 0, rand);
        this.addBlock(world, 3, 6, 1, mainBlock, 0, rand);
        this.addBlock(world, 3, 6, 6, mainBlock, 0, rand);
        this.addBlock(world, 3, 7, 1, windowBlock, 0);
        this.addBlock(world, 3, 7, 6, windowBlock, 0);
        this.addBlock(world, 3, 8, 1, mainBlock, 0, rand);
        this.addBlock(world, 3, 8, 6, mainBlock, 0, rand);
        this.addBlock(world, 3, 9, 2, mainBlock, 0, rand);
        this.addBlock(world, 3, 9, 3, mainBlock, 0, rand);
        this.addBlock(world, 3, 9, 4, mainBlock, 0, rand);
        this.addBlock(world, 3, 9, 5, mainBlock, 0, rand);
        this.addBlock(world, 4, 0, 0, mainBlock, 0, rand);
        this.addBlock(world, 4, 0, 1, mainBlock, 0, rand);
        this.addBlock(world, 4, 0, 2, mainBlock, 0, rand);
        this.addBlock(world, 4, 0, 3, secondBlock, 0);
        this.addBlock(world, 4, 0, 4, secondBlock, 0);
        this.addBlock(world, 4, 0, 5, mainBlock, 0, rand);
        this.addBlock(world, 4, 0, 6, mainBlock, 0, rand);
        this.addBlock(world, 4, 0, 7, mainBlock, 0, rand);
        this.addBlock(world, 4, 4, 0, mainBlock, 0, rand);
        this.addBlock(world, 4, 4, 1, secondBlock, 0);
        this.addBlock(world, 4, 4, 2, secondBlock, 0);
        this.addBlock(world, 4, 4, 3, secondBlock, 0);
        this.addBlock(world, 4, 4, 4, secondBlock, 0);
        this.addBlock(world, 4, 4, 5, secondBlock, 0);
        this.addBlock(world, 4, 4, 6, secondBlock, 0);
        this.addBlock(world, 4, 4, 7, mainBlock, 0, rand);
        this.addBlock(world, 4, 5, 1, mainBlock, 0, rand);
        this.addBlock(world, 4, 5, 6, mainBlock, 0, rand);
        this.addBlock(world, 4, 6, 1, mainBlock, 0, rand);
        this.addBlock(world, 4, 6, 6, mainBlock, 0, rand);
        this.addBlock(world, 4, 7, 1, windowBlock, 0);
        this.addBlock(world, 4, 7, 6, windowBlock, 0);
        this.addBlock(world, 4, 8, 1, mainBlock, 0, rand);
        this.addBlock(world, 4, 8, 6, mainBlock, 0, rand);
        this.addBlock(world, 4, 9, 2, mainBlock, 0, rand);
        this.addBlock(world, 4, 9, 3, mainBlock, 0, rand);
        this.addBlock(world, 4, 9, 4, mainBlock, 0, rand);
        this.addBlock(world, 4, 9, 5, mainBlock, 0, rand);
        this.addBlock(world, 5, 0, 0, mainBlock, 0, rand);
        this.addBlock(world, 5, 0, 1, mainBlock, 0, rand);
        this.addBlock(world, 5, 0, 2, mainBlock, 0, rand);
        this.addBlock(world, 5, 0, 3, mainBlock, 0, rand);
        this.addBlock(world, 5, 0, 4, mainBlock, 0, rand);
        this.addBlock(world, 5, 0, 5, mainBlock, 0, rand);
        this.addBlock(world, 5, 0, 6, mainBlock, 0, rand);
        this.addBlock(world, 5, 0, 7, mainBlock, 0, rand);
        this.addBlock(world, 5, 1, 0, mainBlock, 0, rand);
        this.addBlock(world, 5, 1, 7, mainBlock, 0, rand);
        this.addBlock(world, 5, 2, 0, mainBlock, 0, rand);
        this.addBlock(world, 5, 2, 7, mainBlock, 0, rand);
        this.addBlock(world, 5, 3, 0, mainBlock, 0, rand);
        this.addBlock(world, 5, 3, 7, mainBlock, 0, rand);
        this.addBlock(world, 5, 4, 0, mainBlock, 0, rand);
        this.addBlock(world, 5, 4, 1, secondBlock, 0);
        this.addBlock(world, 5, 4, 2, secondBlock, 0);
        this.addBlock(world, 5, 4, 3, secondBlock, 0);
        this.addBlock(world, 5, 4, 4, secondBlock, 0);
        this.addBlock(world, 5, 4, 5, secondBlock, 0);
        this.addBlock(world, 5, 4, 6, secondBlock, 0);
        this.addBlock(world, 5, 4, 7, mainBlock, 0, rand);
        this.addBlock(world, 5, 5, 1, mainBlock, 0, rand);
        this.addBlock(world, 5, 5, 6, mainBlock, 0, rand);
        this.addBlock(world, 5, 6, 1, mainBlock, 0, rand);
        this.addBlock(world, 5, 6, 6, mainBlock, 0, rand);
        this.addBlock(world, 5, 7, 1, mainBlock, 0, rand);
        this.addBlock(world, 5, 7, 6, mainBlock, 0, rand);
        this.addBlock(world, 5, 8, 1, mainBlock, 0, rand);
        this.addBlock(world, 5, 8, 6, mainBlock, 0, rand);
        this.addBlock(world, 5, 9, 2, mainBlock, 0, rand);
        this.addBlock(world, 5, 9, 3, mainBlock, 0, rand);
        this.addBlock(world, 5, 9, 4, mainBlock, 0, rand);
        this.addBlock(world, 5, 9, 5, mainBlock, 0, rand);
        this.addBlock(world, 6, 0, 0, accentBlock, 1);
        this.addBlock(world, 6, 0, 1, mainBlock, 0, rand);
        this.addBlock(world, 6, 0, 2, mainBlock, 0, rand);
        this.addBlock(world, 6, 0, 3, mainBlock, 0, rand);
        this.addBlock(world, 6, 0, 4, mainBlock, 0, rand);
        this.addBlock(world, 6, 0, 5, mainBlock, 0, rand);
        this.addBlock(world, 6, 0, 6, mainBlock, 0, rand);
        this.addBlock(world, 6, 0, 7, accentBlock, 1);
        this.addBlock(world, 6, 1, 1, mainBlock, 0, rand);
        this.addBlock(world, 6, 1, 6, mainBlock, 0, rand);
        this.addBlock(world, 6, 2, 1, wallBlock, 0);
        this.addBlock(world, 6, 2, 6, wallBlock, 0);
        this.addBlock(world, 6, 3, 1, wallBlock, 0);
        this.addBlock(world, 6, 3, 6, wallBlock, 0);
        this.addBlock(world, 6, 4, 0, accentBlock, 1);
        this.addBlock(world, 6, 4, 1, wallBlock, 0);
        this.addBlock(world, 6, 4, 2, secondBlock, 0);
        this.addBlock(world, 6, 4, 3, secondBlock, 0);
        this.addBlock(world, 6, 4, 4, secondBlock, 0);
        this.addBlock(world, 6, 4, 5, secondBlock, 0);
        this.addBlock(world, 6, 4, 6, wallBlock, 0);
        this.addBlock(world, 6, 4, 7, accentBlock, 1);
        this.addBlock(world, 6, 5, 1, wallBlock, 0);
        this.addBlock(world, 6, 5, 2, mainBlock, 0, rand);
        this.addBlock(world, 6, 5, 3, mainBlock, 0, rand);
        this.addBlock(world, 6, 5, 4, mainBlock, 0, rand);
        this.addBlock(world, 6, 5, 5, mainBlock, 0, rand);
        this.addBlock(world, 6, 5, 6, wallBlock, 0);
        this.addBlock(world, 6, 6, 1, wallBlock, 0);
        this.addBlock(world, 6, 6, 2, mainBlock, 0, rand);
        this.addBlock(world, 6, 6, 3, mainBlock, 0, rand);
        this.addBlock(world, 6, 6, 4, mainBlock, 0, rand);
        this.addBlock(world, 6, 6, 5, mainBlock, 0, rand);
        this.addBlock(world, 6, 6, 6, wallBlock, 0);
        this.addBlock(world, 6, 7, 1, wallBlock, 0);
        this.addBlock(world, 6, 7, 2, mainBlock, 0, rand);
        this.addBlock(world, 6, 7, 3, windowBlock, 0);
        this.addBlock(world, 6, 7, 4, windowBlock, 0);
        this.addBlock(world, 6, 7, 5, mainBlock, 0, rand);
        this.addBlock(world, 6, 7, 6, wallBlock, 0);
        this.addBlock(world, 6, 8, 1, wallBlock, 0);
        this.addBlock(world, 6, 8, 2, mainBlock, 0, rand);
        this.addBlock(world, 6, 8, 3, mainBlock, 0, rand);
        this.addBlock(world, 6, 8, 4, mainBlock, 0, rand);
        this.addBlock(world, 6, 8, 5, mainBlock, 0, rand);
        this.addBlock(world, 6, 8, 6, wallBlock, 0);
        this.addBlock(world, 6, 9, 1, wallBlock, 0);
        this.addBlock(world, 6, 9, 6, wallBlock, 0);
        this.addBlock(world, 6, 10, 1, wallBlock, 0);
        this.addBlock(world, 6, 10, 6, wallBlock, 0);
        this.addBlock(world, 7, 0, 1, accentBlock, 1);
        this.addBlock(world, 7, 0, 2, mainBlock, 0, rand);
        this.addBlock(world, 7, 0, 3, mainBlock, 0, rand);
        this.addBlock(world, 7, 0, 4, mainBlock, 0, rand);
        this.addBlock(world, 7, 0, 5, mainBlock, 0, rand);
        this.addBlock(world, 7, 0, 6, accentBlock, 1);
        this.addBlock(world, 7, 1, 2, mainBlock, 0, rand);
        this.addBlock(world, 7, 1, 5, mainBlock, 0, rand);
        this.addBlock(world, 7, 2, 2, mainBlock, 0, rand);
        this.addBlock(world, 7, 2, 5, mainBlock, 0, rand);
        this.addBlock(world, 7, 3, 2, mainBlock, 0, rand);
        this.addBlock(world, 7, 3, 5, mainBlock, 0, rand);
        this.addBlock(world, 7, 4, 1, accentBlock, 1);
        this.addBlock(world, 7, 4, 2, mainBlock, 0, rand);
        this.addBlock(world, 7, 4, 3, mainBlock, 0, rand);
        this.addBlock(world, 7, 4, 4, mainBlock, 0, rand);
        this.addBlock(world, 7, 4, 5, mainBlock, 0, rand);
        this.addBlock(world, 7, 4, 6, accentBlock, 1);
        if (!this.lootChests.getChestPlaced(0)) {
            this.lootChests.setChestPlaced(0, this.generateStructureChestContents(world, box, rand, 2, 5, 2, 5));
        }
        if (!this.lootChests.getChestPlaced(1)) {
            this.lootChests.setChestPlaced(1, this.generateStructureChestContents(world, box, rand, 2, 5, 5, 5));
        }
        if (!this.lootChests.getChestPlaced(2)) {
            this.lootChests.setChestPlaced(2, this.generateStructureChestContents(world, box, rand, 5, 5, 2, 4));
        }
        if (!this.lootChests.getChestPlaced(3)) {
            this.lootChests.setChestPlaced(3, this.generateStructureChestContents(world, box, rand, 5, 5, 5, 4));
        }
        return true;
    }

    protected void addBlock(World world, int x, int y, int z, Block block, int meta, Random rand) {
        double val = rand.nextDouble();
        if (val < 0.25) {
            meta = 1;
        } else if (val >= 0.25 && val < 0.5) {
            meta = 2;
        }
        this.addBlock(world, x, y, z, block, meta);
    }
}

