/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.blocks;

import com.lightningcraft.blocks.LCBlocks;
import com.lightningcraft.items.blocks.ItemSlabLC;
import com.lightningcraft.registry.IRegistryBlock;
import com.lightningcraft.util.JointList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSlabLC
extends BlockSlab
implements IRegistryBlock {
    public static final int nVariants = 4;
    public static final int THUNDER = 0;
    public static final int DEMON = 1;
    public static final int UNDER = 2;
    public static final int UNDER_PLANK = 3;
    private static final PropertyInteger VAR = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)3);

    public BlockSlabLC(Material mat) {
        super(mat);
        IBlockState blockState = this.field_176227_L.func_177621_b();
        blockState = blockState.func_177226_a((IProperty)VAR, (Comparable)Integer.valueOf(0));
        if (!this.func_176552_j()) {
            blockState = blockState.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(blockState);
    }

    public BlockSlabLC() {
        this(Material.field_151576_e);
        this.func_149711_c(10.0f);
        this.func_149752_b(100.0f);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        ItemStack tool = player.func_70694_bm();
        switch (this.func_176201_c(world.func_180495_p(pos))) {
            case 3: {
                return true;
            }
        }
        return super.canHarvestBlock(world, pos, player);
    }

    public String getHarvestTool(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 3: {
                return "axe";
            }
        }
        return super.getHarvestTool(state);
    }

    public float func_180647_a(EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        switch (this.func_176201_c(state)) {
            case 3: {
                float hardness = this.func_176195_g(world, pos);
                if (hardness < 0.0f) {
                    return 0.0f;
                }
                return player.getBreakSpeed(state, pos) / hardness / 30.0f;
            }
        }
        return super.func_180647_a(player, world, pos);
    }

    public float func_176195_g(World world, BlockPos pos) {
        switch (this.func_176201_c(world.func_180495_p(pos))) {
            case 3: {
                return LCBlocks.woodPlank.func_176195_g(world, pos);
            }
        }
        return super.func_176195_g(world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity e, Explosion explosion) {
        switch (this.func_176201_c(world.func_180495_p(pos))) {
            case 3: {
                return LCBlocks.woodPlank.getExplosionResistance(world, pos, e, explosion);
            }
        }
        return super.getExplosionResistance(world, pos, e, explosion);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 4; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    protected BlockState func_180661_e() {
        if (this.func_176552_j()) {
            return new BlockState((Block)this, new IProperty[]{VAR});
        }
        return new BlockState((Block)this, new IProperty[]{VAR, field_176554_a});
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState blockState = this.func_176223_P();
        blockState = blockState.func_177226_a((IProperty)VAR, (Comparable)Integer.valueOf(meta % 8));
        if (!this.func_176552_j()) {
            BlockSlab.EnumBlockHalf value = BlockSlab.EnumBlockHalf.BOTTOM;
            if (meta >= 8) {
                value = BlockSlab.EnumBlockHalf.TOP;
            }
            blockState = blockState.func_177226_a((IProperty)field_176554_a, (Comparable)value);
        }
        return blockState;
    }

    public int func_176201_c(IBlockState state) {
        if (!this.func_176552_j() && (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            return 8 + (Integer)state.func_177229_b((IProperty)VAR);
        }
        return (Integer)state.func_177229_b((IProperty)VAR);
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VAR);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)LCBlocks.slabBlock);
    }

    public boolean func_176552_j() {
        return false;
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    public IProperty func_176551_l() {
        return VAR;
    }

    public Object func_176553_a(ItemStack stack) {
        return stack.func_77952_i();
    }

    public Class getItemClass() {
        return ItemSlabLC.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRender(ItemModelMesher mesher) {
        if (!this.func_176552_j()) {
            int meta;
            JointList<ResourceLocation> names = new JointList<ResourceLocation>();
            Item item = Item.func_150898_a((Block)this);
            for (meta = 0; meta < 4; ++meta) {
                names.join(new ResourceLocation("lightningcraft:" + this.getShorthandName() + "_" + meta));
            }
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])names.toArray(new ResourceLocation[names.size()]));
            for (meta = 0; meta < 4; ++meta) {
                mesher.func_178086_a(item, meta, new ModelResourceLocation("lightningcraft:" + this.getShorthandName() + "_" + meta, "inventory"));
            }
        }
    }
}

