/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.config;

import com.lightningcraft.config.ConfigurationCustom;
import com.lightningcraft.integration.cofh.CoFH;
import com.lightningcraft.ref.Log;
import java.io.File;

public class LCConfig {
    public static int thorEnchID;
    public static int auraEnchID;
    public static int demonFriendPotionID;
    public static int underworldBiomeID;
    public static int underworldDimensionID;
    public static boolean JEIIntegration;
    public static boolean RFIntegration;
    public static int RFtoLEConversion;

    private static void setDefaultValues() {
        thorEnchID = 80;
        auraEnchID = 81;
        demonFriendPotionID = 150;
        underworldBiomeID = 212;
        underworldDimensionID = -9;
        JEIIntegration = true;
        RFIntegration = true;
        RFtoLEConversion = 50;
    }

    public static void loadConfig(File f) {
        ConfigurationCustom config = new ConfigurationCustom(f);
        LCConfig.setDefaultValues();
        config.load();
        thorEnchID = config.getInt("handOfThor.ID", "Enchantments", thorEnchID, "The Hand of Thor enchantment ID");
        auraEnchID = config.getInt("elecAura.ID", "Enchantments", auraEnchID, "The Electrostatic Aura enchantment ID");
        demonFriendPotionID = config.getInt("demonFriend.ID", "Potions", demonFriendPotionID, "The Demon Warding potion effect ID");
        underworldBiomeID = config.getInt("biomes.underworld.ID", "Worldgen", underworldBiomeID, "The Underworld biome ID");
        underworldDimensionID = config.getInt("dimensions.underworld.ID", "Worldgen", underworldDimensionID, "The Underworld dimension ID");
        JEIIntegration = config.getBoolean("JEI.integration", "Mod Integration", RFIntegration, "Enable JEI integration?");
        RFIntegration = config.getBoolean("RF.integration", "Mod Integration", RFIntegration, "Enable LE <-> RF conversion machines?");
        if (!RFIntegration) {
            CoFH.apiLoaded = false;
        }
        RFtoLEConversion = config.getInt("RF.LE.conversion", "Mod Integration", RFtoLEConversion, "This amount of RF is equal to 1 LE (for 1 LE -> x RF conversion). The reverse will be 10 times costlier.");
        if (config.hasChanged()) {
            config.save();
        }
        Log.logger.info("Config loaded.");
    }
}

