/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.gui.server;

import com.lightningcraft.gui.ShortSender;
import com.lightningcraft.tiles.TileEntityLightningUser;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ContainerLightningUser
extends Container {
    private TileEntityLightningUser tile;
    private Short lowStored = null;
    private Short highStored = null;
    private Short lowMax = null;
    private Short highMax = null;

    protected ContainerLightningUser(InventoryPlayer player, TileEntityLightningUser tile) {
        this.tile = tile;
    }

    public int sendUpdate(ICrafting craft, int n) {
        int cellPower = (int)(this.tile.cellPower * 10.0);
        int maxPower = (int)this.tile.maxPower;
        craft.func_71112_a((Container)this, n++, (int)ShortSender.getLowShort(cellPower));
        craft.func_71112_a((Container)this, n++, (int)ShortSender.getHighShort(cellPower));
        craft.func_71112_a((Container)this, n++, (int)ShortSender.getLowShort(maxPower));
        craft.func_71112_a((Container)this, n++, (int)ShortSender.getHighShort(maxPower));
        return n;
    }

    public void func_75132_a(ICrafting craft) {
        super.func_75132_a(craft);
        int n = this.sendUpdate(craft, 1000);
        craft.func_71112_a((Container)this, n++, (int)(this.tile.getEfficiency() * 1000.0));
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting craft = (ICrafting)this.field_75149_d.get(i);
            int n = this.sendUpdate(craft, 1000);
            craft.func_71112_a((Container)this, n++, (int)(this.tile.getEfficiency() * 1000.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int par1, int par2) {
        if (par1 == 1000) {
            this.lowStored = (short)par2;
        }
        if (par1 == 1001) {
            this.highStored = (short)par2;
        }
        if (this.lowStored != null && this.highStored != null) {
            this.tile.cellPower = (double)ShortSender.getInt(this.lowStored, this.highStored) / 10.0;
        }
        if (par1 == 1002) {
            this.lowMax = (short)par2;
        }
        if (par1 == 1003) {
            this.highMax = (short)par2;
        }
        if (this.lowMax != null && this.highMax != null) {
            this.tile.maxPower = ShortSender.getInt(this.lowMax, this.highMax);
        }
        if (par1 == 1004) {
            this.tile.setEfficiency((double)par2 / 1000.0);
        }
    }
}

