/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.recipes;

import com.lightningcraft.blocks.LCBlocks;
import com.lightningcraft.items.LCItems;
import com.lightningcraft.util.JointList;
import com.lightningcraft.util.StackHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class LightningCrusherRecipes {
    private static LightningCrusherRecipes instance = new LightningCrusherRecipes();
    private int recipeIndex = 0;
    private JointList<LightningCrusherRecipe> recipes = new JointList();

    public static LightningCrusherRecipes instance() {
        return instance;
    }

    private LightningCrusherRecipes() {
        this.addDefaultRecipes();
    }

    private void addDefaultRecipes() {
        this.addRecipe(new ItemStack(Blocks.field_150351_n), new ItemStack(Blocks.field_150348_b, 1, Short.MAX_VALUE));
        this.addRecipe(new ItemStack(Blocks.field_150351_n), "cobblestone");
        this.addRecipe(new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150351_n));
        this.addRecipe(new ItemStack((Block)Blocks.field_150354_m), "blockGlass");
        this.addRecipe(new ItemStack((Block)Blocks.field_150354_m), "sandstone");
        this.addRecipe(new ItemStack(Items.field_151114_aO, 4), "glowstone");
        this.addRecipe(new ItemStack(Items.field_151055_y, 16), "logWood");
        this.addRecipe(new ItemStack(Items.field_151055_y, 4), "plankWood");
        this.addRecipe(new ItemStack(Items.field_151055_y, 2), "treeSapling");
        this.addRecipe(new ItemStack(Items.field_151102_aT, 4), new ItemStack(Items.field_151120_aE));
        this.addRecipe(new ItemStack(Items.field_151116_aA, 5), new ItemStack(Items.field_151141_av));
        this.addRecipe(new ItemStack(Items.field_151126_ay, 4), new ItemStack(Blocks.field_150433_aE));
        this.addRecipe(new ItemStack(Items.field_151126_ay, 6), new ItemStack(Blocks.field_150432_aD));
        this.addRecipe(new ItemStack(Items.field_151126_ay, 8), new ItemStack(Blocks.field_150403_cj));
        this.addRecipe(new ItemStack(Items.field_151119_aD, 4), new ItemStack(Blocks.field_150435_aG));
        this.addRecipe(new ItemStack(Items.field_179562_cC, 4), new ItemStack(Blocks.field_180397_cI, 1, 0));
        this.addRecipe(new ItemStack(Items.field_179562_cC, 9), new ItemStack(Blocks.field_180397_cI, 1, 1));
        this.addRecipe(new ItemStack(Items.field_179562_cC, 8), new ItemStack(Blocks.field_180397_cI, 1, 2));
        this.addRecipe(new ItemStack(Items.field_179563_cD), new ItemStack(Items.field_179562_cC));
        this.addRecipe(new ItemStack(Items.field_179563_cD, 4), new ItemStack(Blocks.field_180398_cJ));
        this.addRecipe(new ItemStack(Items.field_151118_aC, 4), new ItemStack(Blocks.field_150336_V));
        this.addRecipe(new ItemStack(Items.field_151130_bT, 4), new ItemStack(Blocks.field_150385_bj));
        this.addRecipe(new ItemStack(Items.field_151016_H, 3), new ItemStack(Items.field_151059_bz));
        this.addRecipe(new ItemStack(Items.field_151065_br, 3), new ItemStack(Items.field_151072_bj));
        this.addRecipe(new ItemStack(Items.field_151100_aR, 6, 15), new ItemStack(Items.field_151103_aS));
        this.addRecipe(new ItemStack(Items.field_151061_bv), "nuggetSkyfather");
        this.addRecipe(new ItemStack((Item)LCItems.material, 1, 5), "nuggetMystic");
        this.addRecipe(new ItemStack((Item)LCItems.material, 6, 8), new ItemStack((Item)LCItems.material, 1, 7));
        this.addRecipe(new ItemStack(Items.field_151100_aR, 2, 15), new ItemStack((Item)LCItems.material, 1, 8));
        this.addRecipe(new ItemStack(Items.field_151137_ax, 6), "oreRedstone");
        this.addRecipe(new ItemStack(Items.field_151100_aR, 9, 4), "oreLapis");
        this.addRecipe(new ItemStack((Item)LCItems.material, 3, 1), "oreDiamond", new ItemStack((Block)LCBlocks.oreBlock, 1, 2));
        this.addRecipe(new ItemStack((Item)LCItems.material, 3, 2), "oreEmerald", new ItemStack((Block)LCBlocks.oreBlock, 1, 3));
        this.addRecipe(new ItemStack((Item)LCItems.material, 4, 3), "oreQuartz");
        this.addRecipe(new ItemStack((Item)LCItems.material, 6, 1), new ItemStack((Block)LCBlocks.oreBlock, 1, 2));
        this.addRecipe(new ItemStack((Item)LCItems.material, 6, 2), new ItemStack((Block)LCBlocks.oreBlock, 1, 3));
        this.addDustRecipes();
    }

    private void addDustRecipes() {
        for (String n : OreDictionary.getOreNames()) {
            boolean gem;
            boolean ore = n.length() >= 3 && n.substring(0, 3).equals("ore");
            boolean ingot = n.length() >= 5 && n.substring(0, 5).equals("ingot");
            boolean bl = gem = n.length() >= 3 && n.substring(0, 3).equals("gem");
            if (!ore && !ingot && !gem || this.recipeExists(n)) continue;
            String type = ore || gem ? n.substring(3, n.length()) : n.substring(5, n.length());
            for (String m : OreDictionary.getOreNames()) {
                if (m.length() < 5 || !m.substring(0, 4).equals("dust") || !m.substring(4, m.length()).equals(type)) continue;
                try {
                    ItemStack result = ((ItemStack)OreDictionary.getOres((String)m).get(0)).func_77946_l();
                    if (ore) {
                        result.field_77994_a = 2;
                    }
                    this.addRecipe(result, n);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public boolean recipeExists(Object input) {
        for (LightningCrusherRecipe r : this.recipes) {
            if (!r.getInputRaw().equals(input)) continue;
            return true;
        }
        return false;
    }

    public void addRecipe(LightningCrusherRecipe r) {
        this.recipes.add(r);
        ++this.recipeIndex;
    }

    public void addRecipe(ItemStack out, Object in) {
        this.addRecipe(new LightningCrusherRecipe(out, in, new ItemStack[0]));
    }

    public void addRecipe(ItemStack out, Object in, ItemStack ... excluding) {
        this.addRecipe(new LightningCrusherRecipe(out, in, excluding));
    }

    public ItemStack getCrushingResult(ItemStack input) {
        for (LightningCrusherRecipe r : this.recipes) {
            for (ItemStack s : r.getInput()) {
                if (!StackHelper.areItemStacksEqualForCrafting(s, input)) continue;
                return r.getOutput();
            }
        }
        return null;
    }

    public List<LightningCrusherRecipe> getRecipeList() {
        return this.recipes;
    }

    public static class LightningCrusherRecipe {
        private Object in;
        private List<ItemStack> excluding;
        private List<ItemStack> inCache;
        private ItemStack out;

        public LightningCrusherRecipe(ItemStack out, Object in, ItemStack ... excluding) {
            if (!(in instanceof List || in instanceof ItemStack || in instanceof String)) {
                throw new IllegalArgumentException("Crusher recipe input invalid.");
            }
            this.in = in;
            this.excluding = new JointList<ItemStack>();
            if (excluding != null) {
                for (ItemStack s : excluding) {
                    this.excluding.add(s.func_77946_l());
                }
            }
            this.inCache = null;
            this.out = out;
        }

        private Object getInputRaw() {
            return this.in;
        }

        private List<ItemStack> getInputBase() {
            if (this.in instanceof List) {
                return (List)this.in;
            }
            if (this.in instanceof ItemStack) {
                return new JointList<Object>().join(((ItemStack)this.in).func_77946_l());
            }
            if (OreDictionary.doesOreNameExist((String)((String)this.in))) {
                return OreDictionary.getOres((String)((String)this.in));
            }
            return new JointList<ItemStack>();
        }

        public List<ItemStack> getInput() {
            if (this.inCache == null) {
                ArrayList<ItemStack> base = new ArrayList<ItemStack>(this.getInputBase());
                for (ItemStack ex : this.excluding) {
                    Iterator iterator = base.iterator();
                    while (iterator.hasNext()) {
                        ItemStack in = (ItemStack)iterator.next();
                        if (!StackHelper.areItemStacksEqualForCrafting(in, ex)) continue;
                        iterator.remove();
                    }
                }
                this.inCache = base;
                return this.inCache;
            }
            return this.inCache;
        }

        public ItemStack getOutput() {
            return this.out.func_77946_l();
        }

        public List<ItemStack> getExcluding() {
            return this.excluding;
        }
    }
}

