/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.tiles;

import com.lightningcraft.blocks.IFurnace;
import com.lightningcraft.blocks.LCBlocks;
import com.lightningcraft.tiles.ISidedInventoryLC;
import com.lightningcraft.tiles.TileEntityLightningUser;
import com.lightningcraft.util.LCMisc;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityEnchReallocator
extends TileEntityLightningUser
implements ISidedInventoryLC {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{1};
    private static final int[] slotsSides = new int[]{1};
    private static final int lpBurnTime = 200;
    private ItemStack[] reallocItemStacks = new ItemStack[2];
    public int reallocBurnTime;
    public int reallocCookTime;
    public int currentBurnTime;
    private String reallocName;
    public List<NBTTagCompound> topEnchs;
    public int nTopEnchs;
    public int lpCost;
    public int xpCost;
    public int xpPlayer;
    public EntityPlayer player = null;
    public boolean hasPlayer = false;

    public int func_70302_i_() {
        return this.reallocItemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.reallocItemStacks[slot];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.reallocItemStacks[par1] != null) {
            if (this.reallocItemStacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.reallocItemStacks[par1];
                this.reallocItemStacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.reallocItemStacks[par1].func_77979_a(par2);
            if (this.reallocItemStacks[par1].field_77994_a == 0) {
                this.reallocItemStacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.reallocItemStacks[slot] != null) {
            ItemStack itemstack = this.reallocItemStacks[slot];
            this.reallocItemStacks[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.reallocItemStacks[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.reallocName : LCBlocks.enchReallocator.func_149732_F();
    }

    public boolean func_145818_k_() {
        return this.reallocName != null && this.reallocName.length() > 0;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.reallocItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tabCompound1 = tagList.func_150305_b(i);
            byte byte0 = tabCompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.reallocItemStacks.length) continue;
            this.reallocItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)tabCompound1);
        }
        this.reallocBurnTime = tagCompound.func_74765_d("BurnTime");
        this.reallocCookTime = tagCompound.func_74765_d("CookTime");
        this.currentBurnTime = 200;
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.reallocName = tagCompound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.reallocBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.reallocBurnTime);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.reallocItemStacks.length; ++i) {
            if (this.reallocItemStacks[i] == null) continue;
            NBTTagCompound tagCompound1 = new NBTTagCompound();
            tagCompound1.func_74774_a("Slot", (byte)i);
            this.reallocItemStacks[i].func_77955_b(tagCompound1);
            tagList.func_74742_a((NBTBase)tagCompound1);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        if (this.func_145818_k_()) {
            tagCompound.func_74778_a("CustomName", this.reallocName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getReallocProgressScaled(int par1) {
        return this.reallocCookTime * par1 / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getReallocTimeRemainingScaled(int par1) {
        if (this.currentBurnTime == 0) {
            this.currentBurnTime = 200;
        }
        return this.reallocBurnTime * par1 / this.currentBurnTime;
    }

    public boolean isBurning() {
        return this.reallocBurnTime > 0;
    }

    public void func_73660_a() {
        boolean flag = this.reallocBurnTime > 0;
        boolean dosave = false;
        if (this.reallocBurnTime > 0) {
            --this.reallocBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.reallocBurnTime == 0 && this.canReallocate()) {
                this.reallocBurnTime = 200;
                this.currentBurnTime = 200;
                if (this.reallocBurnTime > 0) {
                    dosave = true;
                }
            }
            if (this.isBurning() && this.canReallocate()) {
                ++this.reallocCookTime;
                if (this.reallocCookTime == 200) {
                    this.reallocCookTime = 0;
                    this.reallocateEnchs();
                    dosave = true;
                }
            } else {
                this.reallocCookTime = 0;
            }
            if (flag != this.reallocBurnTime > 0) {
                dosave = true;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                ((IFurnace)state.func_177230_c()).setBurning(state, (IBlockAccess)this.field_145850_b, this.field_174879_c, this.reallocBurnTime > 0);
            }
        }
        if (dosave) {
            this.func_70296_d();
        }
    }

    private boolean canReallocate() {
        this.topEnchs = null;
        this.xpCost = -1;
        this.lpCost = -1;
        this.nTopEnchs = 0;
        if (!this.hasLPCell()) {
            return false;
        }
        ItemStack top = this.reallocItemStacks[0];
        ItemStack bottom = this.reallocItemStacks[1];
        List<NBTTagCompound> topEnchs = LCMisc.getEnchantments(top);
        if (!topEnchs.isEmpty()) {
            this.topEnchs = topEnchs;
            this.nTopEnchs = topEnchs.size();
        }
        if (top != null && bottom != null && !topEnchs.isEmpty() && (bottom.func_77956_u() || bottom.func_77973_b() == Items.field_151122_aG)) {
            this.xpCost = top.func_82838_A() + bottom.func_82838_A() + 5;
            this.lpCost = 50 + this.xpCost;
            return this.canDrawCellPower(this.lpCost) && this.xpCost <= this.xpPlayer && this.player != null && this.hasPlayer;
        }
        return false;
    }

    private void reallocateEnchs() {
        if (this.canReallocate()) {
            this.drawCellPower(this.lpCost);
            if (!this.player.field_71075_bZ.field_75098_d) {
                ((EntityPlayerMP)this.player).func_82242_a(-this.xpCost);
            }
            this.hasPlayer = false;
            int topCost = this.reallocItemStacks[0].func_82838_A();
            int bottomCost = this.reallocItemStacks[1].func_82838_A();
            if (this.reallocItemStacks[0].func_77973_b() == Items.field_151134_bR) {
                this.reallocItemStacks[0] = new ItemStack(Items.field_151122_aG, 1);
            } else if (this.reallocItemStacks[0].func_77978_p().func_74764_b("ench")) {
                this.reallocItemStacks[0].func_77978_p().func_82580_o("ench");
            }
            this.reallocItemStacks[0].func_82841_c(topCost + 5);
            if (this.reallocItemStacks[1].func_77973_b() == Items.field_151122_aG) {
                this.reallocItemStacks[1] = new ItemStack((Item)Items.field_151134_bR, 1);
            }
            LCMisc.addEnchantments(this.reallocItemStacks[1], this.topEnchs);
            this.reallocItemStacks[1].func_82841_c(bottomCost + 5);
        }
    }

    public boolean func_94041_b(int par1, ItemStack itemstack) {
        return true;
    }

    public int[] func_180463_a(EnumFacing facing) {
        int par1 = facing.func_176745_a();
        return par1 == 0 ? slotsBottom : (par1 == 1 ? slotsSides : slotsTop);
    }

    public boolean func_180462_a(int par1, ItemStack itemstack, EnumFacing facing) {
        return this.func_94041_b(par1, itemstack);
    }

    public boolean func_180461_b(int par1, ItemStack itemstack, EnumFacing facing) {
        return facing.func_176745_a() != 0 || par1 == 1 || itemstack.func_77973_b() == Items.field_151133_ar;
    }
}

