/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.tiles;

import com.lightningcraft.entities.EntityLCElectricAttack;
import com.lightningcraft.tiles.TileEntityLightningUser;
import com.lightningcraft.util.JointList;
import com.lightningcraft.util.WorldUtils;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLightningCannon
extends TileEntityLightningUser {
    public static final int maxIdleTicks = 400;
    public static final int minIdleTicks = 40;
    public static final double lePerAttack = 20.0;
    private int ticksUntilNextAttack;
    private int currentTicks = 0;
    private double tileX;
    private double tileY;
    private double tileZ;
    public EnumMode mode = EnumMode.access$000();

    public TileEntityLightningCannon() {
        this.ticksUntilNextAttack = this.reload();
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }

    private int reload() {
        return this.random.nextInt(360) + 40;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.tileX = (double)this.getX() + 0.5;
            this.tileY = (double)this.getY() + 0.5;
            this.tileZ = (double)this.getZ() + 0.5;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            int meta = state.func_177230_c().func_176201_c(state);
            EntityPlayer target = null;
            boolean doAttack = false;
            boolean hasCell = false;
            boolean drawPower = false;
            ++this.currentTicks;
            if (meta == 1) {
                hasCell = this.hasLPCell();
            }
            if (this.currentTicks > this.ticksUntilNextAttack) {
                doAttack = true;
                if (meta == 0) {
                    target = WorldUtils.getClosestVulnerablePlayer(this.field_145850_b, this.tileX, this.tileY, this.tileZ, 32.0, new JointList<UUID>());
                } else if (hasCell && this.canDrawCellPower(20.0)) {
                    drawPower = true;
                    switch (this.mode) {
                        case MOBS: {
                            target = (EntityLivingBase)WorldUtils.getClosestVulnerableEntityOfType(this.field_145850_b, this.tileX, this.tileY, this.tileZ, 32.0, IMob.class, new Class[0]);
                            break;
                        }
                        case ALL: {
                            target = (EntityLivingBase)WorldUtils.getClosestVulnerableEntityOfType(this.field_145850_b, this.tileX, this.tileY, this.tileZ, 32.0, EntityLiving.class, new Class[0]);
                            break;
                        }
                    }
                }
            }
            if (doAttack) {
                if (target != null && this.canEntityBeSeen((Entity)target)) {
                    EntityLCElectricAttack bolt = new EntityLCElectricAttack(this.field_145850_b, this.tileX, this.tileY, this.tileZ, (Entity)target);
                    this.field_145850_b.func_72838_d((Entity)bolt);
                    this.field_145850_b.func_72956_a((Entity)bolt, "fireworks.blast", 3.0f, 0.1f);
                    if (drawPower) {
                        this.drawCellPower(20.0);
                    }
                }
                this.ticksUntilNextAttack = this.reload();
                this.currentTicks = 0;
                this.func_70296_d();
            }
        }
    }

    public void rotateOperatingMode() {
        this.mode = EnumMode.assignMode((this.mode.id + 1) % EnumMode.values().length);
        this.func_70296_d();
    }

    public boolean canEntityBeSeen(Entity e) {
        return this.field_145850_b.func_72933_a(new Vec3(this.tileX + 1.0, this.tileY, this.tileZ + 0.0), new Vec3(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) == null || this.field_145850_b.func_72933_a(new Vec3(this.tileX + 0.0, this.tileY, this.tileZ + 1.0), new Vec3(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) == null || this.field_145850_b.func_72933_a(new Vec3(this.tileX - 1.0, this.tileY, this.tileZ + 0.0), new Vec3(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) == null || this.field_145850_b.func_72933_a(new Vec3(this.tileX + 0.0, this.tileY, this.tileZ - 1.0), new Vec3(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) == null;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.ticksUntilNextAttack = tagCompound.func_74762_e("ticksUntilNextAttack");
        this.currentTicks = tagCompound.func_74762_e("currentTicks");
        this.mode = EnumMode.assignMode(tagCompound.func_74762_e("operatingMode"));
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("ticksUntilNextAttack", this.ticksUntilNextAttack);
        tagCompound.func_74768_a("currentTicks", this.currentTicks);
        tagCompound.func_74768_a("operatingMode", this.mode.id);
    }

    public static enum EnumMode {
        NONE(0, "Cannon Inactive"),
        MOBS(1, "Hostile Mobs Only"),
        ALL(2, "All Non-Player Entities");

        private static EnumMode DEFAULT;
        private int id;
        private String name;

        private EnumMode(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getID() {
            return this.id;
        }

        public static EnumMode assignMode(int id) {
            for (EnumMode m : EnumMode.values()) {
                if (m.id != id) continue;
                return m;
            }
            return DEFAULT;
        }

        static /* synthetic */ EnumMode access$000() {
            return DEFAULT;
        }

        static {
            DEFAULT = NONE;
        }
    }
}

