/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.tiles;

import com.lightningcraft.tiles.TileEntityBase;
import com.lightningcraft.tiles.TileEntityLightningCell;
import com.lightningcraft.tiles.TileEntityLightningReceiver;
import com.lightningcraft.tiles.TileEntityLightningTransmitter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;

public abstract class TileEntityLightningUser
extends TileEntityBase {
    public TileEntityLightningCell tileCell;
    public double cellPower;
    public double maxPower;
    private double efficiency;

    protected boolean hasLPCell() {
        TileEntity tile;
        int z;
        int y;
        int x;
        if (this.field_145850_b == null) {
            return false;
        }
        for (x = this.getX() - 1; x <= this.getX() + 1; ++x) {
            for (y = this.getY() - 1; y <= this.getY() + 1; ++y) {
                for (z = this.getZ() - 1; z <= this.getZ() + 1; ++z) {
                    if (x == this.getX() && y == this.getY() && z == this.getZ() || (tile = this.field_145850_b.func_175625_s(new BlockPos(x, y, z))) == null || !(tile instanceof TileEntityLightningCell)) continue;
                    this.tileCell = (TileEntityLightningCell)tile;
                    this.cellPower = this.tileCell.storedPower;
                    this.maxPower = this.tileCell.maxPower;
                    this.setEfficiency(1.0);
                    return true;
                }
            }
        }
        if (!(this instanceof TileEntityLightningTransmitter)) {
            for (x = this.getX() - 1; x <= this.getX() + 1; ++x) {
                for (y = this.getY() - 1; y <= this.getY() + 1; ++y) {
                    for (z = this.getZ() - 1; z <= this.getZ() + 1; ++z) {
                        if (x == this.getX() && y == this.getY() && z == this.getZ() || (tile = this.field_145850_b.func_175625_s(new BlockPos(x, y, z))) == null || !(tile instanceof TileEntityLightningReceiver)) continue;
                        TileEntityLightningReceiver rx = (TileEntityLightningReceiver)tile;
                        if (rx.tx == null || !rx.tx.hasLPCell()) continue;
                        this.tileCell = rx.tx.tileCell;
                        this.cellPower = this.tileCell.storedPower;
                        this.maxPower = this.tileCell.maxPower;
                        this.setEfficiency(rx.efficiency);
                        return true;
                    }
                }
            }
        }
        this.tileCell = null;
        this.cellPower = 0.0;
        this.maxPower = -1.0;
        this.setEfficiency(-1.0);
        return false;
    }

    protected boolean isRemotelyPowered() {
        return this.getEfficiency() < 1.0;
    }

    protected boolean canDrawCellPower(double amount) {
        return this.getEfficiency() > 0.0 && this.cellPower >= amount / this.getEfficiency() && this.tileCell.storedPower >= amount / this.getEfficiency();
    }

    protected boolean canAddCellPower(double amount) {
        return this.getEfficiency() > 0.0 && this.cellPower + amount * this.getEfficiency() <= this.maxPower && this.tileCell.storedPower + amount * this.getEfficiency() <= this.tileCell.maxPower;
    }

    public double getActualNeededPower(double amount) {
        if (this.getEfficiency() > 0.0) {
            return amount / this.getEfficiency();
        }
        return Double.NaN;
    }

    protected boolean drawCellPower(double amount) {
        if (this.canDrawCellPower(amount)) {
            this.cellPower -= amount / this.getEfficiency();
            this.tileCell.storedPower -= amount / this.getEfficiency();
            return true;
        }
        return false;
    }

    protected boolean addCellPower(double amount) {
        if (this.canAddCellPower(amount)) {
            this.cellPower += amount * this.getEfficiency();
            this.tileCell.storedPower += amount * this.getEfficiency();
            return true;
        }
        return false;
    }

    public double getEfficiency() {
        return this.efficiency;
    }

    public void setEfficiency(double efficiency) {
        this.efficiency = efficiency;
    }
}

