/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.tiles;

import com.lightningcraft.blocks.IFurnace;
import com.lightningcraft.blocks.LCBlocks;
import com.lightningcraft.tiles.ISidedInventoryLC;
import com.lightningcraft.tiles.TileEntityLightningUser;
import com.lightningcraft.util.Effect;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityStaticGenerator
extends TileEntityLightningUser
implements ISidedInventoryLC {
    private static final int[] slotsTop = new int[]{0};
    private static final int lpBurnTime = 10;
    private ItemStack[] generatorItemStacks = new ItemStack[1];
    public int generatorBurnTime;
    public int generatorCookTime;
    public int currentBurnTime;
    private String generatorName;
    public double storedCharge;
    private static final double chargePerBlock = 0.8;
    private static final double chanceOfDrain = 0.25;

    public void infuserName(String string) {
        this.generatorName = string;
    }

    public int func_70302_i_() {
        return this.generatorItemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.generatorItemStacks[slot];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.generatorItemStacks[par1] != null) {
            if (this.generatorItemStacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.generatorItemStacks[par1];
                this.generatorItemStacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.generatorItemStacks[par1].func_77979_a(par2);
            if (this.generatorItemStacks[par1].field_77994_a == 0) {
                this.generatorItemStacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.generatorItemStacks[slot] != null) {
            ItemStack itemstack = this.generatorItemStacks[slot];
            this.generatorItemStacks[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.generatorItemStacks[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.generatorName : LCBlocks.staticGenerator.func_149732_F();
    }

    public boolean func_145818_k_() {
        return this.generatorName != null && this.generatorName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.generatorItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tabCompound1 = tagList.func_150305_b(i);
            byte byte0 = tabCompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.generatorItemStacks.length) continue;
            this.generatorItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)tabCompound1);
        }
        this.generatorBurnTime = tagCompound.func_74765_d("BurnTime");
        this.generatorCookTime = tagCompound.func_74765_d("CookTime");
        this.storedCharge = tagCompound.func_74769_h("StoredCharge");
        this.currentBurnTime = 10;
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.generatorName = tagCompound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.generatorBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.generatorBurnTime);
        tagCompound.func_74780_a("StoredCharge", this.storedCharge);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.generatorItemStacks.length; ++i) {
            if (this.generatorItemStacks[i] == null) continue;
            NBTTagCompound tagCompound1 = new NBTTagCompound();
            tagCompound1.func_74774_a("Slot", (byte)i);
            this.generatorItemStacks[i].func_77955_b(tagCompound1);
            tagList.func_74742_a((NBTBase)tagCompound1);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        if (this.func_145818_k_()) {
            tagCompound.func_74778_a("CustomName", this.generatorName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.generatorCookTime * par1 / 10;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentBurnTime == 0) {
            this.currentBurnTime = 10;
        }
        return this.generatorBurnTime * par1 / this.currentBurnTime;
    }

    public boolean isBurning() {
        return this.generatorBurnTime > 0;
    }

    public void func_73660_a() {
        boolean burning = this.generatorCookTime > 0;
        boolean dosave = false;
        if (this.generatorBurnTime > 0) {
            --this.generatorBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.generatorBurnTime == 0 && this.canGenerate()) {
                this.generatorBurnTime = 10;
                this.currentBurnTime = 10;
                if (this.generatorBurnTime > 0) {
                    dosave = true;
                }
            }
            if (this.isBurning() && this.canGenerate()) {
                ++this.generatorCookTime;
                if (this.generatorCookTime == 10) {
                    this.generatorCookTime = 0;
                    this.generate();
                    dosave = true;
                }
            } else {
                this.generatorCookTime = 0;
            }
            if (burning != this.generatorCookTime > 0) {
                dosave = true;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                ((IFurnace)state.func_177230_c()).setBurning(state, (IBlockAccess)this.field_145850_b, this.field_174879_c, this.generatorCookTime > 0);
            }
        }
        if (dosave) {
            this.func_70296_d();
        }
    }

    private boolean canGenerate() {
        if (!this.hasLPCell() || this.isRemotelyPowered()) {
            return false;
        }
        if (this.generatorItemStacks[0] != null) {
            if (this.tileCell.storedPower < 0.5) {
                return false;
            }
            if (this.generatorItemStacks[0].func_77973_b() instanceof ItemBlock) {
                return true;
            }
        }
        return false;
    }

    private void generate() {
        if (this.canGenerate()) {
            double currentCost = this.random.nextDouble() <= 0.25 ? 0.5 : 0.01;
            this.drawCellPower(currentCost);
            this.storedCharge += 0.8;
            if (this.storedCharge >= 100.0 && this.cellPower < this.maxPower - 100.0 * this.tileCell.efficiency) {
                Effect.lightningGen(this.field_145850_b, this.tileCell.func_174877_v().func_177984_a());
                this.storedCharge = 0.0;
            }
            if (this.generatorItemStacks[0] != null) {
                --this.generatorItemStacks[0].field_77994_a;
                if (this.generatorItemStacks[0].field_77994_a <= 0) {
                    this.generatorItemStacks[0] = null;
                }
            }
        }
    }

    public boolean func_94041_b(int par1, ItemStack itemstack) {
        return true;
    }

    public int[] func_180463_a(EnumFacing facing) {
        return slotsTop;
    }

    public boolean func_180462_a(int par1, ItemStack itemstack, EnumFacing facing) {
        return this.func_94041_b(par1, itemstack);
    }

    public boolean func_180461_b(int par1, ItemStack itemstack, EnumFacing facing) {
        return true;
    }
}

