/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.entities;

import com.lightningcraft.blocks.LCBlocks;
import com.lightningcraft.particles.LCParticles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityLCElectricAttack
extends EntityFireball {
    public double startX;
    public double startY;
    public double startZ;

    public EntityLCElectricAttack(World world) {
        super(world);
        this.startX = this.field_70165_t;
        this.startY = this.field_70163_u;
        this.startZ = this.field_70161_v;
    }

    public EntityLCElectricAttack(World world, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.startX = x;
        this.startY = y;
        this.startZ = z;
    }

    public EntityLCElectricAttack(World world, double x, double y, double z, Entity target) {
        this(world, x, y, z, 0.0, 0.0, 0.0);
        double vz;
        double vy;
        double vx;
        if (target != null) {
            vx = target.field_70165_t - x;
            vy = target.field_70163_u + 1.0 - y;
            vz = target.field_70161_v - z;
        } else {
            vx = 1.0;
            vy = 1.0;
            vz = 1.0;
        }
        double d6 = MathHelper.func_76133_a((double)(vx * vx + vy * vy + vz * vz));
        this.field_70232_b = vx / d6 * 0.125;
        this.field_70233_c = vy / d6 * 0.125;
        this.field_70230_d = vz / d6 * 0.125;
        this.field_70178_ae = true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70066_B();
        if (this.field_70170_p.field_72995_K) {
            double d = 0.2125;
            double xoff = 0.0;
            double yoff = 0.0;
            double zoff = 0.0;
            for (int i = 0; i < 12; ++i) {
                xoff = this.field_70146_Z.nextGaussian();
                yoff = this.field_70146_Z.nextGaussian();
                zoff = this.field_70146_Z.nextGaussian();
                LCParticles.spawnParticle("electricAttack", this.field_70165_t + (xoff - 0.5) * d, this.field_70163_u + (yoff - 0.5) * d, this.field_70161_v + (zoff - 0.5) * d, 0.0, 0.0, 0.0);
            }
        } else if (this.field_70232_b == 0.0 && this.field_70233_c == 0.0 && this.field_70230_d == 0.0) {
            this.func_70106_y();
        }
    }

    protected void func_70227_a(RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K) {
            if (mop.field_72308_g != null) {
                if (mop.field_72308_g.func_70097_a(DamageSource.func_76358_a(null), 21.0f)) {
                    if (!mop.field_72308_g.func_70045_F()) {
                        mop.field_72308_g.func_70015_d(2);
                    }
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.WEATHER, 6.0f, 2.0f);
                }
            } else {
                BlockPos pos = mop.func_178782_a();
                int j = 0;
                int i = 0;
                int k = 0;
                if (this.field_70170_p.func_180495_p(pos).func_177230_c() == LCBlocks.lightningCannon) {
                    return;
                }
                switch (mop.field_178784_b.func_176745_a()) {
                    case 0: {
                        --j;
                        break;
                    }
                    case 1: {
                        ++j;
                        break;
                    }
                    case 2: {
                        --k;
                        break;
                    }
                    case 3: {
                        ++k;
                        break;
                    }
                    case 4: {
                        --i;
                        break;
                    }
                    case 5: {
                        ++i;
                    }
                }
                pos = pos.func_177982_a(i, j, k);
                if (this.field_70170_p.func_175623_d(pos)) {
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                }
            }
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.WEATHER, 6.0f, 2.0f);
            this.func_70106_y();
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return true;
    }
}

