/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.items;

import com.lightningcraft.items.ItemLC;
import com.lightningcraft.util.JointList;
import java.util.List;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMeta
extends ItemLC {
    public int nSubItems;
    public boolean sameIcon;
    public boolean[] hasEffect;

    public ItemMeta(int nSubItems, boolean sameIcon, boolean ... hasEffect) {
        this.nSubItems = nSubItems;
        this.sameIcon = sameIcon;
        this.field_77787_bX = true;
        this.hasEffect = hasEffect;
    }

    public ItemMeta(int nSubItems) {
        this(nSubItems, false, false);
    }

    public ItemMeta(int nSubItems, EnumRarity rarity) {
        super(rarity);
        this.nSubItems = nSubItems;
        this.sameIcon = false;
        this.field_77787_bX = true;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List sub) {
        for (int meta = 0; meta < this.nSubItems; ++meta) {
            sub.add(new ItemStack(item, 1, meta));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "_" + stack.func_77952_i();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        int index = stack.func_77952_i();
        if (this.hasEffect != null) {
            return this.hasEffect[Math.min(index, this.hasEffect.length - 1)];
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRender(ItemModelMesher mesher) {
        JointList<ResourceLocation> names = new JointList<ResourceLocation>();
        if (this.sameIcon) {
            int meta;
            for (meta = 0; meta < this.nSubItems; ++meta) {
                names.join(new ResourceLocation("lightningcraft:" + this.getShorthandName()));
            }
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])names.toArray(new ResourceLocation[names.size()]));
            for (meta = 0; meta < this.nSubItems; ++meta) {
                mesher.func_178086_a((Item)this, meta, new ModelResourceLocation("lightningcraft:" + this.getShorthandName(), "inventory"));
            }
        } else {
            int meta;
            for (meta = 0; meta < this.nSubItems; ++meta) {
                names.join(new ResourceLocation("lightningcraft:" + this.getShorthandName() + "_" + meta));
            }
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])names.toArray(new ResourceLocation[names.size()]));
            for (meta = 0; meta < this.nSubItems; ++meta) {
                mesher.func_178086_a((Item)this, meta, new ModelResourceLocation("lightningcraft:" + this.getShorthandName() + "_" + meta, "inventory"));
            }
        }
    }
}

