/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.recipes;

import com.lightningcraft.blocks.LCBlocks;
import com.lightningcraft.items.LCItems;
import com.lightningcraft.util.JointList;
import com.lightningcraft.util.LCMisc;
import com.lightningcraft.util.StackHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class LightningInfusionRecipes {
    public static final String nullIdentifier = "NULL";
    private static final int itemsNeeded = 4;
    private static LightningInfusionRecipes instance = new LightningInfusionRecipes();
    private int recipeIndex = 0;
    private JointList<LightningInfusionRecipe> recipes = new JointList();
    private int lastResultCost = -2;
    private static final int ANY = Short.MAX_VALUE;

    public static LightningInfusionRecipes instance() {
        return instance;
    }

    private LightningInfusionRecipes() {
        this.addDefaultRecipes();
    }

    private void addDefaultRecipes() {
        ItemStack thunderstone = new ItemStack((Block)LCBlocks.stoneBlock, 1, 0);
        ItemStack demonBlood = new ItemStack((Item)LCItems.material, 1, 5);
        ItemStack ichor = new ItemStack((Item)LCItems.material, 1, 11);
        ItemStack prismarine = new ItemStack(Blocks.field_180397_cI, 1, Short.MAX_VALUE);
        ItemStack wool = new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE);
        String dust = "dustMystic";
        this.addRecipe(new ItemStack((Block)Blocks.field_150330_I), 10, "treeSapling", Blocks.field_150354_m);
        this.addRecipe(new ItemStack(Blocks.field_150435_aG, 3), 15, Blocks.field_150346_d, Blocks.field_150351_n, Blocks.field_150354_m, Items.field_151068_bn);
        this.addRecipe(new ItemStack(Blocks.field_150360_v), 10, wool, "slimeball");
        this.addRecipe(new ItemStack(Blocks.field_150403_cj), 15, Blocks.field_150432_aD, LCMisc.makeArray(Blocks.field_150432_aD, 3));
        this.addRecipe(new ItemStack(Blocks.field_150341_Y), 10, "cobblestone", Blocks.field_150395_bd);
        this.addRecipe(new ItemStack(Blocks.field_150342_X, 2), 10, "logWood", LCMisc.makeArray(Items.field_151122_aG, 4));
        this.addRecipe(new ItemStack(Items.field_151128_bU), 40, new ItemStack(Blocks.field_150348_b, 1, 1), LCMisc.makeArray(new ItemStack(Blocks.field_150348_b, 1, 3), 2));
        this.addRecipe(new ItemStack(Items.field_151045_i), 50, Blocks.field_150402_ci, LCMisc.makeArray(Items.field_151044_h, 4));
        this.addRecipe(new ItemStack(Items.field_151166_bC), 75, prismarine, LCMisc.makeArray(Items.field_179563_cD, 4));
        this.addRecipe(new ItemStack((Item)LCItems.ingot, 1, 0), 30, "ingotIron", "ingotGold", "gemDiamond");
        this.addRecipe(new ItemStack((Block)LCBlocks.metalBlock, 1, 0), 270, "blockIron", "blockGold", "blockDiamond");
        int spCost = 90;
        this.addRecipe(new ItemStack((Item)LCItems.soulSword), spCost, Items.field_151052_q, LCMisc.makeArray(Blocks.field_150425_aM, 4));
        this.addRecipe(new ItemStack((Item)LCItems.zombieSword), spCost, Items.field_151052_q, LCMisc.makeArray(Items.field_151078_bh, 4));
        this.addRecipe(new ItemStack((Item)LCItems.featherSword), spCost, Items.field_151052_q, LCMisc.makeArray(Items.field_151008_G, 4));
        this.addRecipe(new ItemStack((Item)LCItems.enderSword), spCost, Items.field_151052_q, LCMisc.makeArray(Items.field_151079_bi, 4));
        this.addRecipe(new ItemStack((Item)LCItems.blazeSword), spCost, Items.field_151052_q, LCMisc.makeArray(Items.field_151072_bj, 4));
        this.addRecipe(new ItemStack((Item)LCItems.iceSword), spCost, Items.field_151052_q, LCMisc.makeArray(Blocks.field_150403_cj, 4));
        this.addRecipe(new ItemStack((Item)LCItems.ingot, 1, 1), 85, "ingotElectricium", thunderstone, Items.field_151061_bv, thunderstone, Items.field_151061_bv);
        this.addRecipe(new ItemStack(Items.field_151129_at), 40, Items.field_151131_as, LCMisc.makeArray(demonBlood, 4));
        this.addRecipe(new ItemStack(Blocks.field_150424_aL, 2), 15, "cobblestone", demonBlood);
        this.addRecipe(new ItemStack(Blocks.field_150385_bj), 25, Blocks.field_150336_V, demonBlood);
        this.addRecipe(new ItemStack(Items.field_151075_bm, 2), 20, Items.field_151014_N, demonBlood);
        this.addRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 1, 3), 35, new ItemStack((Block)LCBlocks.stoneBlock, 1, 0), demonBlood, demonBlood);
        this.addRecipe(new ItemStack((Item)LCItems.material, 1, 6), 100, Items.field_151059_bz, "dustDiamond", demonBlood, Blocks.field_150343_Z);
        this.addRecipe(new ItemStack((Item)LCItems.material, 1, 9), 250, new ItemStack((Item)LCItems.material, 1, 4), "dustDiamond", demonBlood, new ItemStack((Item)LCItems.material, 1, 8), demonBlood);
        this.addRecipe(new ItemStack((Item)LCItems.potion, 1, 0), 50, new ItemStack((Item)Items.field_151068_bn), demonBlood, Items.field_151150_bK, demonBlood, Items.field_151150_bK);
        this.addRecipe(new ItemStack((Item)LCItems.potion, 1, 2048), 25, new ItemStack((Item)LCItems.potion, 1, 0), LCMisc.makeArray("dustRedstone", 4));
        this.addRecipe(new ItemStack((Item)LCItems.ingot, 2, 2), 160, "ingotSkyfather", "nuggetNetherStar", demonBlood, ichor, demonBlood);
        this.addRecipe(new ItemStack((Item)LCItems.mysticHammer), 360, LCItems.skyHammer, LCMisc.makeArray(dust, 4));
        this.addRecipe(new ItemStack((Item)LCItems.mysticSword), 300, LCItems.skySword, LCMisc.makeArray(dust, 4));
        this.addRecipe(new ItemStack((Item)LCItems.mysticPick), 240, LCItems.skyPick, LCMisc.makeArray(dust, 4));
        this.addRecipe(new ItemStack((Item)LCItems.mysticAxe), 240, LCItems.skyAxe, LCMisc.makeArray(dust, 4));
        this.addRecipe(new ItemStack((Item)LCItems.mysticShovel), 240, LCItems.skyShovel, LCMisc.makeArray(dust, 4));
        this.addRecipe(new ItemStack((Item)LCItems.mysticHoe), 200, LCItems.skyHoe, LCMisc.makeArray(dust, 4));
        this.addRecipe(new ItemStack((Item)LCItems.mysticHelm), 240, LCItems.skyHelm, LCMisc.makeArray(dust, 4));
        this.addRecipe(new ItemStack((Item)LCItems.mysticChest), 360, LCItems.skyChest, LCMisc.makeArray(dust, 4));
        this.addRecipe(new ItemStack((Item)LCItems.mysticLegs), 300, LCItems.skyLegs, LCMisc.makeArray(dust, 4));
        this.addRecipe(new ItemStack((Item)LCItems.mysticBoots), 240, LCItems.skyBoots, LCMisc.makeArray(dust, 4));
    }

    public void addRecipe(LightningInfusionRecipe r) {
        this.recipes.add(r);
        ++this.recipeIndex;
    }

    public void addRecipe(ItemStack output, int cost, Object infuse, Object ... surrounding) {
        this.addRecipe(new LightningInfusionRecipe(output, cost, infuse, surrounding));
    }

    private boolean hasResult(ItemStack infuse, String item, List<String> itemOres) {
        String newInfuse;
        String useItem = StackHelper.makeStringFromItemStack(infuse);
        if (item.equals(useItem) || itemOres.contains(useItem)) {
            return true;
        }
        if (StackHelper.getMetaFromString(item) == Short.MAX_VALUE && (newInfuse = StackHelper.stripMetaFromString(item)).equals(StackHelper.stripMetaFromString(useItem))) {
            return true;
        }
        for (String s : itemOres) {
            String cutInfuseOre;
            if (StackHelper.getMetaFromString(s) != Short.MAX_VALUE || !(cutInfuseOre = StackHelper.stripMetaFromString(s)).equals(StackHelper.stripMetaFromString(useItem))) continue;
            return true;
        }
        return false;
    }

    public boolean hasBaseResult(ItemStack infuse1) {
        if (infuse1 == null) {
            return false;
        }
        ItemStack infuse = infuse1.func_77946_l();
        infuse.field_77994_a = 1;
        for (LightningInfusionRecipe recipe : this.recipes) {
            if (!this.hasResult(infuse, recipe.getInfuseItem(), recipe.getInfuseItemAsOre())) continue;
            return true;
        }
        return false;
    }

    public ItemStack getInfusionResult(ItemStack infuse1, ItemStack ... stacks1) {
        if (stacks1.length != 4) {
            return null;
        }
        ItemStack infuse = infuse1.func_77946_l();
        infuse.field_77994_a = 1;
        JointList stacks = new JointList();
        for (int s = 0; s < stacks1.length; ++s) {
            if (stacks1[s] != null) {
                ItemStack current = stacks1[s].func_77946_l();
                current.field_77994_a = 1;
                stacks.add(current);
                continue;
            }
            stacks.add(null);
        }
        for (LightningInfusionRecipe recipe : this.recipes) {
            int valid = 0;
            JointList itemList = new JointList();
            JointList oreList = new JointList();
            for (String string : recipe.getItems()) {
                itemList.add(string);
            }
            for (List list : recipe.getItemsAsOres()) {
                oreList.add(list);
            }
            if (this.hasResult(infuse, recipe.getInfuseItem(), recipe.getInfuseItemAsOre())) {
                ++valid;
            }
            for (ItemStack itemStack : stacks) {
                String stackString = itemStack == null ? nullIdentifier : StackHelper.makeStringFromItemStack(itemStack);
                String modStackString = StackHelper.changeStringMeta(stackString, Short.MAX_VALUE);
                if (itemList.contains(stackString)) {
                    itemList.remove(stackString);
                    ++valid;
                    continue;
                }
                if (itemList.contains(modStackString)) {
                    itemList.remove(modStackString);
                    ++valid;
                    continue;
                }
                List matchList = LCMisc.listListContains(oreList, stackString);
                if (matchList != null) {
                    oreList.remove(matchList);
                    ++valid;
                    continue;
                }
                matchList = LCMisc.listListContains(oreList, modStackString);
                if (matchList == null) continue;
                oreList.remove(matchList);
                ++valid;
            }
            if (valid != 5) continue;
            this.lastResultCost = recipe.getCost();
            return recipe.getOutput().func_77946_l();
        }
        this.lastResultCost = -2;
        return null;
    }

    public int getLastResultCost() {
        return this.lastResultCost;
    }

    public List<LightningInfusionRecipe> getRecipeList() {
        return this.recipes;
    }

    public static class LightningInfusionRecipe {
        private ItemStack output;
        private String infuse;
        private List<String> items;
        private int cost;

        public LightningInfusionRecipe(ItemStack output, int cost, Object infuse, Object ... surrounding) {
            ArrayList<Object> items = new ArrayList<Object>(Arrays.asList(surrounding));
            if (items.size() > 4) {
                throw new IllegalArgumentException("There must be at most 4 surrounding items in an infusion recipe.");
            }
            while (items.size() < 4) {
                items.add(null);
            }
            this.output = output;
            this.cost = cost;
            if (infuse == null) {
                throw new IllegalArgumentException("The infused item cannot be null!");
            }
            this.infuse = infuse instanceof Block ? StackHelper.makeStringFromItemStack(new ItemStack((Block)infuse)) : (infuse instanceof Item ? StackHelper.makeStringFromItemStack(new ItemStack((Item)infuse)) : StackHelper.makeStringFromItemStack(infuse));
            this.items = new JointList<String>();
            for (Object e : items) {
                if (e == null) {
                    this.items.add(LightningInfusionRecipes.nullIdentifier);
                    continue;
                }
                if (e instanceof Block) {
                    this.items.add(StackHelper.makeStringFromItemStack(new ItemStack((Block)e)));
                    continue;
                }
                if (e instanceof Item) {
                    this.items.add(StackHelper.makeStringFromItemStack(new ItemStack((Item)e)));
                    continue;
                }
                this.items.add(StackHelper.makeStringFromItemStack(e));
            }
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getCost() {
            return this.cost;
        }

        public String getInfuseItem() {
            return this.infuse;
        }

        public List<String> getInfuseItemAsOre() {
            JointList<String> list = new JointList<String>();
            for (ItemStack s : OreDictionary.getOres((String)this.infuse)) {
                list.add(StackHelper.makeStringFromItemStack(s));
            }
            return list;
        }

        public List<String> getItems() {
            return this.items;
        }

        public List<List<String>> getItemsAsOres() {
            JointList<List<String>> list = new JointList<List<String>>();
            for (String name : this.items) {
                JointList list2 = new JointList();
                for (ItemStack s : OreDictionary.getOres((String)name)) {
                    list2.add(StackHelper.makeStringFromItemStack(s));
                }
                list.add(list2);
            }
            return list;
        }
    }
}

