/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.tiles;

import cofh.api.energy.IEnergyProvider;
import com.lightningcraft.config.LCConfig;
import com.lightningcraft.tiles.TileEntityRF;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="cofh.api.energy.IEnergyProvider", modid="CoFHAPI")
public class TileEntityRFProvider
extends TileEntityRF
implements IEnergyProvider {
    public static final int maxStorage = 100000;
    public static final int rfPerTick = 1024;
    private int storedRF = 0;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.hasLPCell() && !this.field_145850_b.func_175640_z(this.field_174879_c) && this.storedRF <= 100000 - LCConfig.RFtoLEConversion && this.canDrawCellPower(1.0)) {
            this.drawCellPower(1.0);
            this.storedRF += LCConfig.RFtoLEConversion;
            if (this.storedRF > 100000) {
                this.storedRF = 100000;
            }
            this.func_70296_d();
        }
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storedRF;
    }

    @Override
    public void setEnergyStored(int energy) {
        if (energy >= 0 && energy <= 100000) {
            this.storedRF = energy;
        }
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return 100000;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int extractEnergy(EnumFacing from, int toExtract, boolean simulate) {
        int maxExtract = Math.max(Math.min(toExtract, 1024), 0);
        int extract = 0;
        if (maxExtract > this.storedRF) {
            extract = this.storedRF;
            if (!simulate) {
                this.storedRF = 0;
            }
        } else {
            extract = maxExtract;
            if (!simulate) {
                this.storedRF -= maxExtract;
            }
        }
        if (!simulate) {
            this.func_70296_d();
        }
        return extract;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.storedRF = tagCompound.func_74762_e("storedRF");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("storedRF", this.storedRF);
    }
}

