/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.tiles;

import cofh.api.energy.IEnergyReceiver;
import com.lightningcraft.config.LCConfig;
import com.lightningcraft.tiles.TileEntityRF;
import com.lightningcraft.util.Effect;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="cofh.api.energy.IEnergyReceiver", modid="CoFHAPI")
public class TileEntityRFReceiver
extends TileEntityRF
implements IEnergyReceiver {
    public static final int maxStorage = 100000;
    public static final int rfPerTick = 512;
    private int storedRF = 0;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.hasLPCell() && !this.isRemotelyPowered() && this.field_145850_b.func_82737_E() % 100L == 0L && !this.field_145850_b.func_175640_z(this.field_174879_c) && this.storedRF >= LCConfig.RFtoLEConversion * 10 * 100 && this.cellPower < this.maxPower - 100.0 * this.tileCell.efficiency) {
            Effect.lightningGen(this.field_145850_b, this.tileCell.func_174877_v().func_177984_a());
            this.storedRF -= LCConfig.RFtoLEConversion * 10 * 100;
            if (this.storedRF < 0) {
                this.storedRF = 0;
            }
            this.func_70296_d();
        }
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storedRF;
    }

    @Override
    public void setEnergyStored(int energy) {
        if (energy >= 0 && energy <= 100000) {
            this.storedRF = energy;
        }
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return 100000;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int receiveEnergy(EnumFacing from, int toReceive, boolean simulate) {
        int maxReceive = Math.max(Math.min(toReceive, 512), 0);
        int receive = 0;
        if (100000 > this.storedRF + maxReceive) {
            receive = maxReceive;
            if (!simulate) {
                this.storedRF += maxReceive;
            }
        } else {
            receive = 100000 - this.storedRF;
            if (!simulate) {
                this.storedRF = 100000;
            }
        }
        if (!simulate) {
            this.func_70296_d();
        }
        return receive;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.storedRF = tagCompound.func_74762_e("storedRF");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("storedRF", this.storedRF);
    }
}

