/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.util;

import com.lightningcraft.entities.EntityLCLightningBolt;
import com.lightningcraft.network.LCNetwork;
import com.lightningcraft.network.MessageSpawnParticle;
import com.lightningcraft.util.WorldUtils;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Effect {
    private static Random random = new Random();

    public static boolean lightningGen(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            EntityLCLightningBolt lightning = new EntityLCLightningBolt(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), false);
            lightning.func_70107_b(pos.func_177958_n(), (double)pos.func_177956_o() - 0.5, pos.func_177952_p());
            world.func_72942_c((Entity)lightning);
            return true;
        }
        return false;
    }

    public static boolean lightning(World world, double x, double y, double z, boolean isRandom, double range) {
        if (!world.field_72995_K) {
            double zoff;
            double xoff;
            if (isRandom) {
                xoff = random.nextDouble() * range * 2.0 - range;
                zoff = random.nextDouble() * range * 2.0 - range;
            } else {
                xoff = 0.0;
                zoff = 0.0;
            }
            x += xoff;
            z += zoff;
            if (isRandom) {
                Integer yy = WorldUtils.getOpenSurface(world, (int)x, (int)z, (int)y, 10);
                if (yy == null) {
                    return false;
                }
                y = yy.intValue();
            }
            EntityLCLightningBolt lightning = new EntityLCLightningBolt(world, x, y, z, true);
            lightning.func_70107_b(x, y - 0.5, z);
            world.func_72942_c((Entity)lightning);
            return true;
        }
        return false;
    }

    public static boolean lightning(World world, double x, double y, double z) {
        return Effect.lightning(world, x, y, z, false, 0.0);
    }

    public static boolean lightning(Entity entity, boolean isRandom, double range) {
        if (!entity.field_70170_p.field_72995_K) {
            double y;
            double zoff;
            double xoff;
            if (isRandom) {
                xoff = random.nextDouble() * range * 2.0 - range;
                zoff = random.nextDouble() * range * 2.0 - range;
            } else {
                xoff = 0.0;
                zoff = 0.0;
            }
            World world = entity.field_70170_p;
            double x = entity.field_70165_t + xoff;
            double z = entity.field_70161_v + zoff;
            if (isRandom) {
                Integer yy = WorldUtils.getOpenSurface(world, (int)x, (int)z, (int)entity.field_70163_u, 10);
                if (yy == null) {
                    return false;
                }
                y = yy.intValue();
            } else {
                y = entity.field_70163_u;
            }
            EntityLCLightningBolt lightning = new EntityLCLightningBolt(world, x, y, z, true);
            lightning.func_70107_b(x, y - 0.5, z);
            world.func_72942_c((Entity)lightning);
            return true;
        }
        return false;
    }

    public static boolean lightning(Entity entity, boolean isRandom) {
        return Effect.lightning(entity, isRandom, 16.0);
    }

    public static void specialSword(String name, World world, double x, double y, double z) {
        int dim = world.field_73011_w.getDimension();
        for (int i = 0; i < 6; ++i) {
            float xoff = (random.nextFloat() - 0.5f) * 2.5f;
            float yoff = (random.nextFloat() + 0.0f) * 2.5f;
            float zoff = (random.nextFloat() - 0.5f) * 2.5f;
            LCNetwork.net.sendToAllAround((IMessage)new MessageSpawnParticle(name, x + (double)xoff, y + (double)yoff, z + (double)zoff, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(dim, x, y, z, 1024.0));
        }
    }

    public static void ender(World world, double x, double y, double z, double tx, double ty, double tz, boolean sound2x) {
        int nParticles = 64;
        float width = 1.0f;
        float height = 2.0f;
        int dim = world.field_73011_w.getDimension();
        for (int l = 0; l < nParticles; ++l) {
            double d6 = (double)l / ((double)nParticles - 1.0);
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d7 = tx + (x - tx) * d6 + (random.nextDouble() - 0.5) * (double)width * 2.0;
            double d8 = ty + (y - ty) * d6 + random.nextDouble() * (double)height;
            double d9 = tz + (z - tz) * d6 + (random.nextDouble() - 0.5) * (double)width * 2.0;
            LCNetwork.net.sendToAllAround((IMessage)new MessageSpawnParticle("portal", d7, d8, d9, f, f1, f2), new NetworkRegistry.TargetPoint(dim, d7, d8, d9, 1024.0));
        }
        float pitch = 0.9f + random.nextFloat() * 0.2f;
        world.func_184148_a(null, x, y, z, SoundEvents.field_187810_eg, SoundCategory.AMBIENT, 1.0f, pitch);
        if (sound2x) {
            world.func_184148_a(null, tx, ty, tz, SoundEvents.field_187810_eg, SoundCategory.AMBIENT, 1.0f, pitch);
        }
    }

    public static void ender(World world, double x, double y, double z, double tx, double ty, double tz) {
        Effect.ender(world, x, y, z, tx, ty, tz, true);
    }
}

