/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.api.registry.ILightningCraftBlock;
import sblectric.lightningcraft.init.LCBlocks;
import sblectric.lightningcraft.items.blocks.ItemSlabLC;

public class BlockSlabLC
extends BlockSlab
implements ILightningCraftBlock {
    public static final int nVariants = 4;
    public static final int THUNDER = 0;
    public static final int DEMON = 1;
    public static final int UNDER = 2;
    public static final int UNDER_PLANK = 3;
    private static final PropertyInteger VAR = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)3);

    public BlockSlabLC(Material mat) {
        super(mat);
        IBlockState blockState = this.field_176227_L.func_177621_b();
        blockState = blockState.func_177226_a((IProperty)VAR, (Comparable)Integer.valueOf(0));
        if (!this.func_176552_j()) {
            blockState = blockState.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(blockState);
    }

    public BlockSlabLC() {
        this(Material.field_151576_e);
        this.func_149711_c(10.0f);
        this.func_149752_b(100.0f);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        switch (this.func_176201_c(state)) {
            case 3: {
                return LCBlocks.woodPlank.func_176195_g(LCBlocks.woodPlank.func_176223_P(), world, pos);
            }
        }
        return super.func_176195_g(state, world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity e, Explosion explosion) {
        switch (this.func_176201_c(world.func_180495_p(pos))) {
            case 3: {
                return LCBlocks.woodPlank.getExplosionResistance(world, pos, e, explosion);
            }
        }
        return super.getExplosionResistance(world, pos, e, explosion);
    }

    public Material func_149688_o(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 3: {
                return LCBlocks.woodPlank.func_149688_o(LCBlocks.woodPlank.func_176223_P());
            }
        }
        return super.func_149688_o(state);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 4; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    protected BlockStateContainer func_180661_e() {
        if (this.func_176552_j()) {
            return new BlockStateContainer((Block)this, new IProperty[]{VAR});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{VAR, field_176554_a});
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState blockState = this.func_176223_P();
        blockState = blockState.func_177226_a((IProperty)VAR, (Comparable)Integer.valueOf(meta % 8));
        if (!this.func_176552_j()) {
            BlockSlab.EnumBlockHalf value = BlockSlab.EnumBlockHalf.BOTTOM;
            if (meta >= 8) {
                value = BlockSlab.EnumBlockHalf.TOP;
            }
            blockState = blockState.func_177226_a((IProperty)field_176554_a, (Comparable)value);
        }
        return blockState;
    }

    public int func_176201_c(IBlockState state) {
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            return 8 + (Integer)state.func_177229_b((IProperty)VAR);
        }
        return (Integer)state.func_177229_b((IProperty)VAR);
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VAR);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)LCBlocks.slabBlock);
    }

    public boolean func_176552_j() {
        return false;
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    public IProperty func_176551_l() {
        return VAR;
    }

    public Comparable func_185674_a(ItemStack stack) {
        return Integer.valueOf(stack.func_77952_i());
    }

    public Class getItemClass() {
        return ItemSlabLC.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRender() {
        Item item = Item.func_150898_a((Block)this);
        for (int meta = 0; meta < 4; ++meta) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_" + meta, "inventory"));
        }
    }
}

