/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.blocks;

import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.api.registry.ILightningCraftBlock;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.dimensions.TeleporterLC;
import sblectric.lightningcraft.init.LCAchievements;
import sblectric.lightningcraft.init.LCBlocks;
import sblectric.lightningcraft.init.LCDimensions;
import sblectric.lightningcraft.init.LCParticles;
import sblectric.lightningcraft.init.LCSoundEvents;
import sblectric.lightningcraft.ref.Log;
import sblectric.lightningcraft.util.WorldUtils;

public class PortalUnderworld
extends BlockPortal
implements ILightningCraftBlock {
    public static PortalStatus portalStatus = new PortalStatus();

    public static boolean ignitePortal(World world, BlockPos pos) {
        if (LCConfig.portalEnabled) {
            return LCBlocks.underPortal.func_176548_d(world, pos);
        }
        return false;
    }

    public PortalUnderworld() {
        this.func_149722_s();
    }

    public Class getItemClass() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity e) {
        if (e.func_184187_bx() == null && e instanceof EntityPlayerMP) {
            portalStatus.setPortal((EntityPlayerMP)e, true);
        }
    }

    public static void doTeleport(EntityPlayerMP p) {
        MinecraftServer server = p.field_71133_b;
        if (p.field_71088_bW > 0) {
            p.field_71088_bW = 10;
        } else if (p.field_71093_bK != LCDimensions.underworldID) {
            p.field_71088_bW = 10;
            Log.logger.info("Sending player " + p.func_70005_c_() + " to Underworld");
            p.func_71064_a((StatBase)LCAchievements.reachUnderworld, 1);
            server.func_184103_al().transferPlayerToDimension(p, LCDimensions.underworldID, (Teleporter)new TeleporterLC(p.field_71093_bK, server.func_71218_a(LCDimensions.underworldID)));
        } else {
            p.field_71088_bW = 10;
            Log.logger.info("Sending player " + p.func_70005_c_() + " to Overworld");
            server.func_184103_al().transferPlayerToDimension(p, 0, (Teleporter)new TeleporterLC(p.field_71093_bK, server.func_71218_a(0)));
        }
        portalStatus.setPortal(p, false);
    }

    public boolean func_176548_d(World worldIn, BlockPos pos) {
        Size size = new Size(worldIn, pos, EnumFacing.Axis.X);
        if (size.isSizeValid() && size.count == 0) {
            size.setPortalState();
            return true;
        }
        Size size1 = new Size(worldIn, pos, EnumFacing.Axis.Z);
        if (size1.isSizeValid() && size1.count == 0) {
            size1.setPortalState();
            return true;
        }
        return false;
    }

    public BlockPattern.PatternHelper func_181089_f(World world, BlockPos pos) {
        EnumFacing.Axis axis = EnumFacing.Axis.Z;
        Size psize = new Size(world, pos, EnumFacing.Axis.X);
        LoadingCache loadingcache = BlockPattern.func_181627_a((World)world, (boolean)true);
        if (!psize.isSizeValid()) {
            axis = EnumFacing.Axis.X;
            psize = new Size(world, pos, EnumFacing.Axis.Z);
        }
        if (!psize.isSizeValid()) {
            return new BlockPattern.PatternHelper(pos, EnumFacing.NORTH, EnumFacing.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[EnumFacing.AxisDirection.values().length];
        EnumFacing enumfacing = psize.face1.func_176735_f();
        BlockPos blockpos = psize.pos.func_177981_b(psize.getSizeY() - 1);
        for (EnumFacing.AxisDirection enumfacing$axisdirection : EnumFacing.AxisDirection.values()) {
            BlockPattern.PatternHelper phelp = new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection ? blockpos : blockpos.func_177967_a(psize.face1, psize.getSizeX() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection, (EnumFacing.Axis)axis), EnumFacing.UP, loadingcache, psize.getSizeX(), psize.getSizeY(), 1);
            for (int i = 0; i < psize.getSizeX(); ++i) {
                for (int j = 0; j < psize.getSizeY(); ++j) {
                    BlockWorldState bws = phelp.func_177670_a(i, j, 1);
                    if (bws.func_177509_a() == null || bws.func_177509_a().func_177230_c().func_149688_o(bws.func_177509_a()) == Material.field_151579_a) continue;
                    int n = enumfacing$axisdirection.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        EnumFacing.AxisDirection enumfacing$axisdirection1 = EnumFacing.AxisDirection.POSITIVE;
        for (EnumFacing.AxisDirection enumfacing$axisdirection2 : EnumFacing.AxisDirection.values()) {
            if (aint[enumfacing$axisdirection2.ordinal()] >= aint[enumfacing$axisdirection1.ordinal()]) continue;
            enumfacing$axisdirection1 = enumfacing$axisdirection2;
        }
        return new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection1 ? blockpos : blockpos.func_177967_a(psize.face1, psize.getSizeX() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection1, (EnumFacing.Axis)axis), EnumFacing.UP, loadingcache, psize.getSizeX(), psize.getSizeY(), 1);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        Size size1;
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a);
        if (axis == EnumFacing.Axis.X) {
            Size size = new Size(worldIn, pos, EnumFacing.Axis.X);
            if (!size.isSizeValid() || size.count < size.sizeX * size.sizeY) {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (!(axis != EnumFacing.Axis.Z || (size1 = new Size(worldIn, pos, EnumFacing.Axis.Z)).isSizeValid() && size1.count >= size1.sizeX * size1.sizeY)) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, LCSoundEvents.portalUnderworld, SoundCategory.AMBIENT, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            LCParticles.spawnParticle("underPortal", d0, d1, d2, d3, d4, d5);
        }
    }

    public static class Size {
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing face1;
        private final EnumFacing face2;
        private int count = 0;
        private BlockPos pos;
        private int sizeY;
        private int sizeX;

        public Size(World worldIn, BlockPos pos, EnumFacing.Axis axis) {
            this.world = worldIn;
            this.axis = axis;
            if (axis == EnumFacing.Axis.X) {
                this.face2 = EnumFacing.EAST;
                this.face1 = EnumFacing.WEST;
            } else {
                this.face2 = EnumFacing.NORTH;
                this.face1 = EnumFacing.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isValidBlock(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c())) {
                pos = pos.func_177977_b();
            }
            int i = this.calcSize(pos, this.face2) - 1;
            if (i >= 0) {
                this.pos = pos.func_177967_a(this.face2, i);
                this.sizeX = this.calcSize(this.pos, this.face1);
                if (this.sizeX < 2 || this.sizeX > 21) {
                    this.pos = null;
                    this.sizeX = 0;
                }
            }
            if (this.pos != null) {
                this.sizeY = this.updateSize();
            }
        }

        protected int calcSize(BlockPos pos, EnumFacing face) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.isValidBlock(this.world.func_180495_p(blockpos = pos.func_177967_a(face, i)).func_177230_c()) && WorldUtils.blockMatches(this.world, blockpos.func_177977_b(), LCBlocks.stoneBlock, 3); ++i) {
            }
            return WorldUtils.blockMatches(this.world, pos.func_177967_a(face, i), LCBlocks.stoneBlock, 3) ? i : 0;
        }

        public int getSizeY() {
            return this.sizeY;
        }

        public int getSizeX() {
            return this.sizeX;
        }

        protected int updateSize() {
            this.sizeY = 0;
            block0: while (this.sizeY < 21) {
                for (int i = 0; i < this.sizeX; ++i) {
                    BlockPos blockpos = this.pos.func_177967_a(this.face1, i).func_177981_b(this.sizeY);
                    Block block = this.world.func_180495_p(blockpos).func_177230_c();
                    if (!this.isValidBlock(block)) break block0;
                    if (block == LCBlocks.underPortal) {
                        ++this.count;
                    }
                    if (i == 0 ? !WorldUtils.blockMatches(this.world, blockpos.func_177972_a(this.face2), LCBlocks.stoneBlock, 3) : i == this.sizeX - 1 && !WorldUtils.blockMatches(this.world, blockpos.func_177972_a(this.face1), LCBlocks.stoneBlock, 3)) break block0;
                }
                ++this.sizeY;
            }
            for (int j = 0; j < this.sizeX; ++j) {
                if (WorldUtils.blockMatches(this.world, this.pos.func_177967_a(this.face1, j).func_177981_b(this.sizeY), LCBlocks.stoneBlock, 3)) continue;
                this.sizeY = 0;
                break;
            }
            if (this.sizeY <= 21 && this.sizeY >= 2) {
                return this.sizeY;
            }
            this.pos = null;
            this.sizeX = 0;
            this.sizeY = 0;
            return 0;
        }

        protected boolean isValidBlock(Block block) {
            return block.func_149688_o(block.func_176223_P()) == Material.field_151579_a || block == LCBlocks.underPortal;
        }

        public boolean isSizeValid() {
            return this.pos != null && this.sizeX >= 2 && this.sizeX <= 21 && this.sizeY >= 2 && this.sizeY <= 21;
        }

        public void setPortalState() {
            for (int i = 0; i < this.sizeX; ++i) {
                BlockPos blockpos = this.pos.func_177967_a(this.face1, i);
                for (int j = 0; j < this.sizeY; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), LCBlocks.underPortal.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)this.axis), 2);
                }
            }
        }
    }

    public static class PortalStatus {
        private Map<String, Boolean> portal = new HashMap<String, Boolean>();
        private Map<String, Integer> cooldown = new HashMap<String, Integer>();

        private PortalStatus() {
        }

        public boolean getPortal(EntityPlayerMP player) {
            if (this.portal.containsKey(player.func_70005_c_())) {
                return this.portal.get(player.func_70005_c_());
            }
            return false;
        }

        public void setPortal(EntityPlayerMP player, boolean doportal) {
            if (this.portal.containsKey(player.func_70005_c_()) || doportal) {
                this.portal.put(player.func_70005_c_(), doportal);
            }
        }

        public void resetCooldown(EntityPlayerMP player) {
            this.cooldown.put(player.func_70005_c_(), LCConfig.portalCooldown);
        }

        public boolean checkCooldown(EntityPlayerMP player) {
            int i;
            int n = i = this.cooldown.containsKey(player.func_70005_c_()) ? this.cooldown.get(player.func_70005_c_()) : 0;
            if (i <= 0) {
                return true;
            }
            this.cooldown.put(player.func_70005_c_(), i - 1);
            return false;
        }
    }
}

