/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.dimensions;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCavesHell;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenMinable;
import sblectric.lightningcraft.init.LCBlocks;
import sblectric.lightningcraft.ref.RefMisc;
import sblectric.lightningcraft.util.LCMisc;
import sblectric.lightningcraft.util.WorldUtils;
import sblectric.lightningcraft.worldgen.MinableHelper;
import sblectric.lightningcraft.worldgen.WorldGenIceShrub;
import sblectric.lightningcraft.worldgen.WorldGenUnderworldLight;
import sblectric.lightningcraft.worldgen.WorldGenUnderworldLiquid;
import sblectric.lightningcraft.worldgen.WorldGenUnderworldTrees;
import sblectric.lightningcraft.worldgen.structure.underworld.MapGenUnderworldRampart;
import sblectric.lightningcraft.worldgen.structure.underworld.MapGenUnderworldTower;
import sblectric.lightningcraft.worldgen.structure.underworld.MapGenUnderworldWaterTemple;

public class ChunkProviderUnderworld
implements IChunkGenerator {
    private Random dimRNG;
    public static final int chunkHeight = 256;
    private NoiseGeneratorOctaves underworldNoiseGen1;
    private NoiseGeneratorOctaves underworldNoiseGen2;
    private NoiseGeneratorOctaves underworldNoiseGen3;
    private NoiseGeneratorOctaves grassandstoneNoiseGen;
    private NoiseGeneratorOctaves understoneExculsivityNoiseGen;
    public NoiseGeneratorOctaves underworldNoiseGen6;
    public NoiseGeneratorOctaves underworldNoiseGen7;
    private World worldObj;
    private double[] noiseField;
    private double[] grassNoise = new double[256];
    private double[] stoneNoise = new double[256];
    private double[] understoneExclusivityNoise = new double[256];
    private MapGenBase underworldCaveGenerator = new MapGenCavesHell();
    public MapGenUnderworldWaterTemple genUnderworldWaterTemple = new MapGenUnderworldWaterTemple();
    public MapGenUnderworldTower genUnderworldTower = new MapGenUnderworldTower();
    public MapGenUnderworldRampart genUnderworldRampart = new MapGenUnderworldRampart();
    public static boolean rampartLoadingExtraChunks = false;
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;

    public ChunkProviderUnderworld(World world, long seed) {
        this.worldObj = world;
        this.dimRNG = new Random(seed - 1L);
        this.underworldNoiseGen1 = new NoiseGeneratorOctaves(this.dimRNG, 16);
        this.underworldNoiseGen2 = new NoiseGeneratorOctaves(this.dimRNG, 16);
        this.underworldNoiseGen3 = new NoiseGeneratorOctaves(this.dimRNG, 8);
        this.grassandstoneNoiseGen = new NoiseGeneratorOctaves(this.dimRNG, 4);
        this.understoneExculsivityNoiseGen = new NoiseGeneratorOctaves(this.dimRNG, 4);
        this.underworldNoiseGen6 = new NoiseGeneratorOctaves(this.dimRNG, 10);
        this.underworldNoiseGen7 = new NoiseGeneratorOctaves(this.dimRNG, 16);
    }

    public void initBlocks(int chunkX, int chunkZ, IBlockState[] blocks) {
        int b0 = 4;
        int b1 = 32;
        int k = b0 + 1;
        int b2 = 33;
        int l = b0 + 1;
        this.noiseField = this.initializeNoiseField(this.noiseField, chunkX * b0, 0, chunkZ * b0, k, b2, l);
        for (int i1 = 0; i1 < b0; ++i1) {
            for (int j1 = 0; j1 < b0; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d0 = 0.125;
                    double d1 = this.noiseField[((i1 + 0) * l + j1 + 0) * b2 + k1 + 0];
                    double d2 = this.noiseField[((i1 + 0) * l + j1 + 1) * b2 + k1 + 0];
                    double d3 = this.noiseField[((i1 + 1) * l + j1 + 0) * b2 + k1 + 0];
                    double d4 = this.noiseField[((i1 + 1) * l + j1 + 1) * b2 + k1 + 0];
                    double d5 = (this.noiseField[((i1 + 0) * l + j1 + 0) * b2 + k1 + 1] - d1) * d0;
                    double d6 = (this.noiseField[((i1 + 0) * l + j1 + 1) * b2 + k1 + 1] - d2) * d0;
                    double d7 = (this.noiseField[((i1 + 1) * l + j1 + 0) * b2 + k1 + 1] - d3) * d0;
                    double d8 = (this.noiseField[((i1 + 1) * l + j1 + 1) * b2 + k1 + 1] - d4) * d0;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            int j2 = i2 + i1 * 4 << 4 + LCMisc.log2(256) | 0 + j1 * 4 << LCMisc.log2(256) | k1 * 8 + l1;
                            int short1 = 256;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState block = Blocks.field_150350_a.func_176223_P();
                                if (k1 * 8 + l1 < b1) {
                                    block = Blocks.field_150355_j.func_176223_P();
                                }
                                if (d15 > 0.0) {
                                    block = LCBlocks.stoneBlock.func_176203_a(6);
                                }
                                blocks[j2] = block;
                                j2 += short1;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBiomeBlocks(int par1, int par2, IBlockState[] blocks, Biome[] biomes) {
        int stoneGrassCanGen = 192;
        int sandCanGen = 31;
        double d0 = 0.03125;
        this.grassNoise = this.grassandstoneNoiseGen.func_76304_a(this.grassNoise, par1 * 16, par2 * 16, 0, 16, 16, 1, d0, d0, 1.0);
        this.stoneNoise = this.grassandstoneNoiseGen.func_76304_a(this.stoneNoise, par1 * 16, 109, par2 * 16, 16, 1, 16, d0, 1.0, d0);
        this.understoneExclusivityNoise = this.understoneExculsivityNoiseGen.func_76304_a(this.understoneExclusivityNoise, par1 * 16, par2 * 16, 0, 16, 16, 1, d0 * 2.0, d0 * 2.0, d0 * 2.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                IBlockState block;
                boolean flag = this.grassNoise[k + l * 16] + this.dimRNG.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.stoneNoise[k + l * 16] + this.dimRNG.nextDouble() * 0.4 > 0.0;
                int i1 = (int)(this.understoneExclusivityNoise[k + l * 16] / 3.0 + 3.0 + this.dimRNG.nextDouble() * 0.25);
                int j1 = -1;
                IBlockState block1 = block = LCBlocks.stoneBlock.func_176203_a(6);
                for (int y = 255; y >= 0; --y) {
                    int l1 = (l * 16 + k) * 256 + y;
                    if (y < 255 - this.dimRNG.nextInt(5) && y > 0 + this.dimRNG.nextInt(5)) {
                        IBlockState block2 = blocks[l1];
                        if (block2 != null && block2.func_177230_c().func_149688_o(block) != Material.field_151579_a) {
                            if (block2 != LCBlocks.stoneBlock.func_176203_a(6)) continue;
                            if (j1 == -1) {
                                if (i1 <= 0) {
                                    block = Blocks.field_150350_a.func_176223_P();
                                    block1 = LCBlocks.stoneBlock.func_176203_a(6);
                                } else if (y >= stoneGrassCanGen - 4 && y <= stoneGrassCanGen + 1) {
                                    block1 = block = LCBlocks.stoneBlock.func_176203_a(6);
                                    if (flag1) {
                                        block = Blocks.field_150348_b.func_176223_P();
                                        block1 = LCBlocks.corruptStone.func_176223_P();
                                    }
                                    if (flag) {
                                        block = Blocks.field_150349_c.func_176223_P();
                                        block1 = Blocks.field_150346_d.func_176223_P();
                                    }
                                }
                                if (block1 == Blocks.field_150346_d.func_176223_P() && y <= sandCanGen) {
                                    block1 = LCBlocks.underSand.func_176223_P();
                                }
                                if (y < stoneGrassCanGen && (block == null || block.func_177230_c().func_149688_o(block) == Material.field_151579_a)) {
                                    block = y <= sandCanGen ? LCBlocks.underSand.func_176223_P() : Blocks.field_150432_aD.func_176223_P();
                                }
                                j1 = i1;
                                if (y >= stoneGrassCanGen - 1) {
                                    blocks[l1] = block;
                                    continue;
                                }
                                if (y + 1 < 256 && (blocks[l1 + 1] == null || blocks[l1 + 1].func_177230_c().func_149688_o(block) == Material.field_151579_a)) {
                                    blocks[l1] = block;
                                    continue;
                                }
                                blocks[l1] = block1;
                                continue;
                            }
                            if (j1 <= 0) continue;
                            --j1;
                            blocks[l1] = block1;
                            continue;
                        }
                        j1 = -1;
                        continue;
                    }
                    blocks[l1] = Blocks.field_150357_h.func_176223_P();
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.dimRNG.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer p = new ChunkPrimer();
        IBlockState[] ablock = new IBlockState[65536];
        Biome[] abiomegenbase = this.worldObj.func_72959_q().func_76933_b(null, x * 16, z * 16, 16, 16);
        this.initBlocks(x, z, ablock);
        this.replaceBiomeBlocks(x, z, ablock, abiomegenbase);
        WorldUtils.primeChunk(p, ablock);
        this.underworldCaveGenerator.func_186125_a(this.worldObj, x, z, p);
        this.genUnderworldWaterTemple.func_186125_a(this.worldObj, x, z, p);
        this.genUnderworldTower.func_186125_a(this.worldObj, x, z, p);
        if (!rampartLoadingExtraChunks) {
            this.genUnderworldRampart.func_186125_a(this.worldObj, x, z, p);
        }
        Chunk chunk = new Chunk(this.worldObj, p, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int k = 0; k < abyte.length; ++k) {
            abyte[k] = (byte)Biome.func_185362_a((Biome)abiomegenbase[k]);
        }
        chunk.func_76613_n();
        return chunk;
    }

    private double[] initializeNoiseField(double[] par1, int par2, int par3, int par4, int par5, int par6, int par7) {
        int i2;
        if (par1 == null) {
            par1 = new double[par5 * par6 * par7];
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.underworldNoiseGen6.func_76304_a(this.noiseData4, par2, par3, par4, par5, 1, par7, 1.0, 0.0, 1.0);
        this.noiseData5 = this.underworldNoiseGen7.func_76304_a(this.noiseData5, par2, par3, par4, par5, 1, par7, 100.0, 0.0, 100.0);
        this.noiseData1 = this.underworldNoiseGen3.func_76304_a(this.noiseData1, par2, par3, par4, par5, par6, par7, d0 / 80.0, d1 / 60.0, d0 / 80.0);
        this.noiseData2 = this.underworldNoiseGen1.func_76304_a(this.noiseData2, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        this.noiseData3 = this.underworldNoiseGen2.func_76304_a(this.noiseData3, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        int k1 = 0;
        int l1 = 0;
        double[] adouble1 = new double[par6];
        for (i2 = 0; i2 < par6; ++i2) {
            adouble1[i2] = Math.cos((double)i2 * Math.PI * 6.0 / (double)par6) * 2.0;
            double d2 = i2;
            if (i2 > par6 / 2) {
                d2 = par6 - 1 - i2;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = i2;
            adouble1[n] = adouble1[n] - d2 * d2 * d2 * 10.0;
        }
        for (i2 = 0; i2 < par5; ++i2) {
            for (int k2 = 0; k2 < par7; ++k2) {
                double d3 = (this.noiseData4[l1] + 256.0) / 512.0;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.noiseData5[l1] / 8000.0;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 /= 2.0;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)par6 / 16.0;
                ++l1;
                for (int j2 = 0; j2 < par6; ++j2) {
                    double d11;
                    double d6 = 0.0;
                    double d7 = adouble1[j2];
                    double d8 = this.noiseData2[k1] / 512.0;
                    double d9 = this.noiseData3[k1] / 512.0;
                    double d10 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (j2 > par6 - 4) {
                        d11 = (float)(j2 - (par6 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)j2 < d4) {
                        d11 = (d4 - (double)j2) / 4.0;
                        if (d11 < 0.0) {
                            d11 = 0.0;
                        }
                        if (d11 > 1.0) {
                            d11 = 1.0;
                        }
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    par1[k1] = d6;
                    ++k1;
                }
            }
        }
        return par1;
    }

    public void func_185931_b(int x, int z) {
        int j2;
        int i2;
        int l1;
        int k1;
        int j1;
        BlockFalling.field_149832_M = true;
        int k = x * 16;
        int l = z * 16;
        if (RefMisc.DEBUG && rampartLoadingExtraChunks) {
            System.out.println("Loading chunk for rampart");
        }
        if (!rampartLoadingExtraChunks) {
            try {
                this.genUnderworldWaterTemple.func_175794_a(this.worldObj, this.dimRNG, new ChunkPos(x, z));
                this.genUnderworldTower.func_175794_a(this.worldObj, this.dimRNG, new ChunkPos(x, z));
                this.genUnderworldRampart.func_175794_a(this.worldObj, this.dimRNG, new ChunkPos(x, z));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean doGen = true;
        int numGen = this.dimRNG.nextInt(this.dimRNG.nextInt(12) + 1) + 4;
        for (j1 = 0; doGen && j1 < numGen; ++j1) {
            k1 = k + this.dimRNG.nextInt(16) + 8;
            l1 = this.dimRNG.nextInt(248) + 4;
            i2 = l + this.dimRNG.nextInt(16) + 8;
            new WorldGenUnderworldLight().func_180709_b(this.worldObj, this.dimRNG, new BlockPos(k1, l1, i2));
        }
        numGen = 96;
        for (j1 = 0; doGen && j1 < numGen; ++j1) {
            k1 = k + this.dimRNG.nextInt(16) + 8;
            l1 = this.dimRNG.nextInt(248) + 4;
            i2 = l + this.dimRNG.nextInt(16) + 8;
            new WorldGenUnderworldTrees(false, 6).func_180709_b(this.worldObj, this.dimRNG, new BlockPos(k1, l1, i2));
        }
        numGen = this.dimRNG.nextInt(this.dimRNG.nextInt(3) + 1) + 1;
        for (j1 = 0; doGen && j1 < numGen; ++j1) {
            k1 = k + this.dimRNG.nextInt(16) + 8;
            l1 = this.dimRNG.nextInt(248) + 4;
            i2 = l + this.dimRNG.nextInt(16) + 8;
            new WorldGenIceShrub().func_180709_b(this.worldObj, this.dimRNG, new BlockPos(k1, l1, i2));
        }
        WorldGenMinable[] ore = new WorldGenMinable[]{new WorldGenMinable(LCBlocks.oreBlock.func_176203_a(0), 20, (Predicate)new MinableHelper(LCBlocks.stoneBlock.func_176203_a(6))), new WorldGenMinable(LCBlocks.oreBlock.func_176203_a(1), 16, (Predicate)new MinableHelper(LCBlocks.stoneBlock.func_176203_a(6))), new WorldGenMinable(LCBlocks.oreBlock.func_176203_a(2), 12, (Predicate)new MinableHelper(LCBlocks.stoneBlock.func_176203_a(6))), new WorldGenMinable(LCBlocks.oreBlock.func_176203_a(3), 8, (Predicate)new MinableHelper(LCBlocks.stoneBlock.func_176203_a(6)))};
        int[] frequency = new int[]{6, 6, 4, 2};
        for (int currentOre = 0; currentOre < 4; ++currentOre) {
            numGen = this.dimRNG.nextInt(this.dimRNG.nextInt((int)((double)frequency[currentOre] * 3.0)) + 1);
            for (k1 = 0; k1 < numGen; ++k1) {
                l1 = k + this.dimRNG.nextInt(16);
                i2 = this.dimRNG.nextInt(236) + 10;
                j2 = l + this.dimRNG.nextInt(16);
                ore[currentOre].func_180709_b(this.worldObj, this.dimRNG, new BlockPos(l1, i2, j2));
            }
        }
        numGen = this.dimRNG.nextInt(this.dimRNG.nextInt(16) + 1) + 2;
        for (k1 = 0; k1 < numGen; ++k1) {
            l1 = k + this.dimRNG.nextInt(16);
            i2 = this.dimRNG.nextInt(236) + 10;
            j2 = l + this.dimRNG.nextInt(16);
            new WorldGenUnderworldLiquid((Block)Blocks.field_150358_i, false).func_180709_b(this.worldObj, this.dimRNG, new BlockPos(l1, i2, j2));
        }
        BlockFalling.field_149832_M = false;
    }

    public List func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        boolean canAccessWorld;
        boolean bl = canAccessWorld = this.genUnderworldTower.canAccessWorld() && this.genUnderworldWaterTemple.canAccessWorld() && this.genUnderworldRampart.canAccessWorld();
        if (canAccessWorld) {
            Biome biomegenbase = this.worldObj.func_180494_b(pos);
            return biomegenbase.func_76747_a(creatureType);
        }
        return null;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        this.genUnderworldWaterTemple.func_186125_a(this.worldObj, x, z, null);
        this.genUnderworldTower.func_186125_a(this.worldObj, x, z, null);
        this.genUnderworldRampart.func_186125_a(this.worldObj, x, z, null);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }
}

