/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.entities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import sblectric.lightningcraft.api.util.JointList;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.init.LCAchievements;
import sblectric.lightningcraft.init.LCDimensions;
import sblectric.lightningcraft.init.LCItems;
import sblectric.lightningcraft.init.LCPotions;
import sblectric.lightningcraft.init.LCSoundEvents;
import sblectric.lightningcraft.util.SkyUtils;

public class EntityDemonSoldier
extends EntityMob {
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("lightningcraft", "entities/demon_soldier");
    protected boolean isTough = false;

    public EntityDemonSoldier(World world, boolean isTough) {
        this(world);
        this.isTough = isTough;
    }

    public EntityDemonSoldier(World world) {
        super(world);
        if (this.field_70146_Z.nextDouble() <= 0.01) {
            this.isTough = true;
        }
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.func_70105_a(0.6f, 1.8f);
        this.field_70178_ae = true;
    }

    public boolean func_175446_cd() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.field_71093_bK == LCDimensions.underworldID || LCConfig.demonSoldiersFullPower) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null) {
                EntityPlayer p = (EntityPlayer)this.findPlayerToAttack();
                if (p != null) {
                    try {
                        this.func_70624_b((EntityLivingBase)p);
                        p.func_145747_a((ITextComponent)new TextComponentString("[Demon Soldier] \u00a74\u00a7oYou will pay for your insolence.\u00a7r"));
                    }
                    catch (Exception exception) {}
                }
            } else if (this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).field_71075_bZ.field_75102_a) {
                this.func_70624_b(null);
            }
            if (this.field_70173_aa % 40 == 0 && this.func_70660_b(LCPotions.demonFriend) != null) {
                this.func_70624_b(null);
                this.func_70097_a(DamageSource.field_76376_m, 0.5f);
            }
        }
    }

    protected Entity findPlayerToAttack() {
        EntityPlayerMP p = (EntityPlayerMP)this.field_70170_p.func_72890_a((Entity)this, 16.0);
        return p != null && !LCConfig.demonSoldiersAlwaysNeutral && !p.field_71075_bZ.field_75102_a && this.func_70685_l((Entity)p) && SkyUtils.isPlayerInsolent(p) ? p : null;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        boolean flag = super.func_70097_a(source, damage);
        if (!this.field_70170_p.field_72995_K) {
            Entity p = source.func_76346_g();
            if (this.func_110143_aJ() > 0.0f && p != null && p instanceof EntityPlayerMP && this.func_70638_az() != p && !((EntityPlayerMP)p).field_71075_bZ.field_75102_a) {
                try {
                    ((EntityPlayerMP)p).func_145747_a((ITextComponent)new TextComponentString("[Demon Soldier] \u00a74\u00a7oWhat a fool.\u00a7r"));
                    this.func_70624_b((EntityLivingBase)((EntityPlayerMP)p));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.func_110143_aJ() <= 0.0f && p instanceof EntityPlayer) {
                ((EntityPlayer)p).func_71064_a((StatBase)LCAchievements.killDemon, 1);
            }
        }
        return flag;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        this.armDemon();
        return livingdata;
    }

    protected void armDemon() {
        JointList<Object> swords = new JointList<Object>().join(new ItemStack((Item)LCItems.soulSword), new ItemStack((Item)LCItems.zombieSword), new ItemStack((Item)LCItems.featherSword), new ItemStack((Item)LCItems.enderSword), new ItemStack((Item)LCItems.blazeSword), new ItemStack((Item)LCItems.iceSword));
        int sel = this.field_70146_Z.nextInt(swords.size());
        ItemStack sword = this.isTough ? new ItemStack((Item)LCItems.skySword) : (ItemStack)swords.get(sel);
        sword.func_77966_a(Enchantments.field_77334_n, 2);
        this.func_184611_a(EnumHand.MAIN_HAND, sword);
        if (this.isTough) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151020_U));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151023_V));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151022_W));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151029_X));
        }
    }

    public int func_70658_aO() {
        int i = super.func_70658_aO() + 8;
        if (i > 23) {
            i = 23;
        }
        return i;
    }

    protected SoundEvent func_184639_G() {
        return LCSoundEvents.demonSoldierIdle;
    }

    protected SoundEvent func_184601_bQ() {
        return LCSoundEvents.demonSoldierHurt;
    }

    protected SoundEvent func_184615_bR() {
        return LCSoundEvents.demonSoldierDeath;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.isTough = tag.func_74767_n("isTough");
    }

    public NBTTagCompound func_189511_e(NBTTagCompound tag) {
        super.func_189511_e(tag);
        tag.func_74757_a("isTough", this.isTough);
        return tag;
    }
}

