/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.api.capabilities.ILightningUpgradable;
import sblectric.lightningcraft.init.LCCapabilities;
import sblectric.lightningcraft.ref.RefMisc;

public class MessageLightningUpgrade
implements IMessage {
    private BlockPos pos;
    private boolean upgraded;

    public MessageLightningUpgrade() {
    }

    public MessageLightningUpgrade(BlockPos pos) {
        this(pos, true);
    }

    public MessageLightningUpgrade(BlockPos pos, boolean upgraded) {
        this.pos = pos;
        this.upgraded = upgraded;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.pos = BlockPos.func_177969_a((long)tag.func_74763_f("pos"));
        this.upgraded = tag.func_74767_n("upgraded");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("pos", this.pos.func_177986_g());
        tag.func_74757_a("upgraded", this.upgraded);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<MessageLightningUpgrade, IMessage> {
        public IMessage onMessage(MessageLightningUpgrade m, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> this.handle(m));
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void handle(MessageLightningUpgrade m) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            TileEntity tile = world.func_175625_s(m.pos);
            if (tile != null && tile.hasCapability(LCCapabilities.LIGHTNING_UPGRADABLE, null)) {
                ((ILightningUpgradable)tile.getCapability(LCCapabilities.LIGHTNING_UPGRADABLE, null)).setUpgraded(m.upgraded);
                if (RefMisc.DEBUG) {
                    System.out.println("Machine upgraded at " + m.pos);
                }
            }
        }
    }
}

