/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.tiles;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import sblectric.lightningcraft.api.capabilities.implementation.BaseLightningUpgradable;
import sblectric.lightningcraft.init.LCCapabilities;
import sblectric.lightningcraft.tiles.TileEntityLightningUser;
import sblectric.lightningcraft.tiles.ifaces.ISidedInventoryLC;
import sblectric.lightningcraft.util.LCMisc;

public abstract class TileEntityLightningItemHandler
extends TileEntityLightningUser
implements ISidedInventoryLC {
    protected SidedInvWrapper[] itemCapabilities = LCMisc.makeInvWrapper(this);
    protected ItemStack[] stacks = new ItemStack[0];

    public int func_70302_i_() {
        return this.stacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.stacks[slot];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.stacks[par1] != null) {
            if (this.stacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.stacks[par1];
                this.stacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.stacks[par1].func_77979_a(par2);
            if (this.stacks[par1].field_77994_a == 0) {
                this.stacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.stacks[slot] != null) {
            ItemStack itemstack = this.stacks[slot];
            this.stacks[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.stacks[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemCapabilities[facing.func_176745_a()];
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.stacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound slotTag = tagList.func_150305_b(i);
            byte slot = slotTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.stacks.length) continue;
            this.stacks[slot] = ItemStack.func_77949_a((NBTTagCompound)slotTag);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null) continue;
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74774_a("Slot", (byte)i);
            this.stacks[i].func_77955_b(slotTag);
            tagList.func_74742_a((NBTBase)slotTag);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        return tagCompound;
    }

    public static abstract class Upgradable
    extends TileEntityLightningItemHandler {
        private BaseLightningUpgradable upgrade = new BaseLightningUpgradable();

        @Override
        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            if (capability == LCCapabilities.LIGHTNING_UPGRADABLE) {
                return true;
            }
            return super.hasCapability(capability, facing);
        }

        @Override
        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == LCCapabilities.LIGHTNING_UPGRADABLE) {
                return (T)this.upgrade;
            }
            return super.getCapability(capability, facing);
        }

        public boolean isUpgraded() {
            return this.upgrade.isUpgraded();
        }

        public void setUpgraded(boolean upgraded) {
            this.upgrade.setUpgraded(upgraded);
        }

        @Override
        public void func_145839_a(NBTTagCompound tagCompound) {
            super.func_145839_a(tagCompound);
            this.upgrade.deserializeNBT(tagCompound);
        }

        @Override
        public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
            super.func_189515_b(tagCompound);
            return this.upgrade.serializeNBT(tagCompound);
        }

        public String func_70005_c_() {
            return this.func_145838_q().func_149732_F() + (this.isUpgraded() ? " (Upgr.)" : "");
        }

        public boolean func_145818_k_() {
            return true;
        }
    }
}

