/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.tiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.api.IFurnace;
import sblectric.lightningcraft.tiles.TileEntityLightningItemHandler;
import sblectric.lightningcraft.util.Effect;

public class TileEntityStaticGenerator
extends TileEntityLightningItemHandler.Upgradable {
    private static final int[] slotsTop = new int[]{0};
    private static final int lpBurnTime = 10;
    private static final double chargePerBlock = 0.8;
    private static final double chanceOfDrain = 0.25;
    public int generatorBurnTime;
    public int generatorCookTime;
    public int currentBurnTime;
    public double storedCharge;
    private boolean redo;

    public TileEntityStaticGenerator() {
        this.stacks = new ItemStack[1];
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.generatorCookTime * par1 / 10;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentBurnTime == 0) {
            this.currentBurnTime = 10;
        }
        return this.generatorBurnTime * par1 / this.currentBurnTime;
    }

    public boolean isBurning() {
        return this.generatorBurnTime > 0;
    }

    public void func_73660_a() {
        boolean burning = this.generatorCookTime > 0;
        boolean dosave = false;
        if (this.generatorBurnTime > 0) {
            --this.generatorBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.generatorBurnTime == 0 && this.canGenerate()) {
                this.generatorBurnTime = 10;
                this.currentBurnTime = 10;
                if (this.generatorBurnTime > 0) {
                    dosave = true;
                }
            }
            if (this.isBurning() && this.canGenerate()) {
                ++this.generatorCookTime;
                if (this.generatorCookTime == 10) {
                    this.generatorCookTime = 0;
                    this.generate();
                    dosave = true;
                }
            } else {
                this.generatorCookTime = 0;
            }
            if (burning != this.generatorCookTime > 0) {
                dosave = true;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                ((IFurnace)state.func_177230_c()).setBurning(state, (IBlockAccess)this.field_145850_b, this.field_174879_c, this.generatorCookTime > 0);
            }
        }
        if (dosave) {
            this.func_70296_d();
        }
        if (this.isUpgraded() && !this.redo) {
            this.redo = true;
            this.func_73660_a();
        }
        this.redo = false;
    }

    private boolean canGenerate() {
        if (!this.hasLPCell() || this.isRemotelyPowered()) {
            return false;
        }
        if (this.stacks[0] != null) {
            if (this.tileCell.storedPower < 0.5) {
                return false;
            }
            if (this.stacks[0].func_77973_b() instanceof ItemBlock) {
                return true;
            }
        }
        return false;
    }

    private void generate() {
        if (this.canGenerate()) {
            double currentCost = this.random.nextDouble() <= 0.25 ? 0.5 : 0.01;
            this.drawCellPower(currentCost);
            this.storedCharge += 0.8;
            if (this.storedCharge >= 100.0 && this.cellPower < this.maxPower - 100.0 * this.tileCell.efficiency) {
                Effect.lightningGen(this.field_145850_b, this.tileCell.func_174877_v().func_177984_a());
                this.storedCharge = 0.0;
            }
            if (this.stacks[0] != null) {
                --this.stacks[0].field_77994_a;
                if (this.stacks[0].field_77994_a <= 0) {
                    this.stacks[0] = null;
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.generatorBurnTime = tagCompound.func_74765_d("BurnTime");
        this.generatorCookTime = tagCompound.func_74765_d("CookTime");
        this.storedCharge = tagCompound.func_74769_h("StoredCharge");
        this.currentBurnTime = 10;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.generatorBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.generatorBurnTime);
        tagCompound.func_74780_a("StoredCharge", this.storedCharge);
        return tagCompound;
    }

    public boolean func_94041_b(int par1, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemBlock;
    }

    public int[] func_180463_a(EnumFacing facing) {
        return slotsTop;
    }

    public boolean func_180462_a(int par1, ItemStack itemstack, EnumFacing facing) {
        return this.func_94041_b(par1, itemstack);
    }

    public boolean func_180461_b(int par1, ItemStack itemstack, EnumFacing facing) {
        return false;
    }
}

