/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.blocks;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import sblectric.lightningcraft.blocks.BlockMeta;
import sblectric.lightningcraft.items.blocks.ItemBlockAirTerminal;
import sblectric.lightningcraft.ref.Metal;
import sblectric.lightningcraft.util.JointList;

public class BlockAirTerminal
extends BlockMeta {
    protected IProperty type;

    public BlockAirTerminal(float hardness, float resistance) {
        super(Blocks.field_150339_S, 10, hardness, resistance, true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 0.9375, (double)0.8f);
    }

    public BlockAirTerminal() {
        this(3.0f, 30.0f);
    }

    @Override
    protected List<IProperty> getProperties() {
        Object[] objectArray = new Object[1];
        this.type = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
        objectArray[0] = this.type;
        return new JointList<Object>().join(objectArray);
    }

    @Override
    protected void setDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.type, (Comparable)((Object)EnumType.DEFAULT)));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.type, (Comparable)((Object)EnumType.getTypeFromMeta(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(this.type))).getID();
    }

    @Override
    public Class getItemClass() {
        return ItemBlockAirTerminal.class;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public double getEfficiency(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 0: {
                return 0.3;
            }
            case 1: {
                return 0.35;
            }
            case 2: {
                return 0.4;
            }
            case 3: {
                return 0.5;
            }
            case 4: {
                return 0.6;
            }
            case 5: {
                return 0.7;
            }
            case 6: {
                return 0.75;
            }
            case 7: {
                return 0.9;
            }
            case 8: {
                return 1.0;
            }
            case 9: {
                return 1.1;
            }
        }
        return 0.25;
    }

    public static enum EnumType implements IStringSerializable
    {
        IRON(0),
        STEEL(1),
        LEAD(2),
        TIN(3),
        ALUM(4),
        GOLD(5),
        COPPER(6),
        ELEC(7),
        SKY(8),
        MYSTIC(9);

        private static final EnumType DEFAULT;
        private int ID;
        private String name;

        private EnumType(int meta) {
            this.ID = meta;
            this.name = Metal.Rod.getNameFromMeta(meta).toLowerCase();
        }

        public static EnumType getTypeFromMeta(int meta) {
            for (EnumType m : EnumType.values()) {
                if (m.ID != meta) continue;
                return m;
            }
            return DEFAULT;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public int getID() {
            return this.ID;
        }

        static {
            DEFAULT = IRON;
        }
    }
}

