/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.blocks.BlockContainerLC;
import sblectric.lightningcraft.items.blocks.ItemBlockMeta;
import sblectric.lightningcraft.ref.RefMisc;
import sblectric.lightningcraft.util.JointList;

public abstract class BlockContainerLCMeta
extends BlockContainerLC {
    private static final PropertyInteger DEFAULT = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)1);
    protected int nSubBlocks;
    public boolean sameIcon;
    private JointList<IProperty> variants = new JointList();

    public BlockContainerLCMeta(Block parent, int nSubBlocks, float hardness, float resistance, EnumBlockRenderType renderType, boolean sameIcon) {
        super(parent, hardness, resistance);
        this.renderType = renderType;
        this.field_149758_A = true;
        if (nSubBlocks > 16) {
            throw new IllegalArgumentException("More than 16 metadata states is unsupported!");
        }
        this.nSubBlocks = nSubBlocks;
        this.sameIcon = sameIcon;
        ReflectionHelper.setPrivateValue(Block.class, (Object)this, (Object)this.func_180661_e(), (String[])new String[]{RefMisc.DEV != false ? "blockState" : "field_176227_L"});
        this.setDefaultState();
    }

    public BlockContainerLCMeta(Block parent, int nSubBlocks, float hardness, float resistance) {
        this(parent, nSubBlocks, hardness, resistance, EnumBlockRenderType.MODEL, false);
    }

    protected List<IProperty> getProperties() {
        this.variants = new JointList<Object>().join(PropertyInteger.func_177719_a((String)"variant", (int)0, (int)(this.nSubBlocks - 1)));
        return this.variants;
    }

    protected void setDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.variants.get(0), (Comparable)Integer.valueOf(0)));
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.nSubBlocks; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    protected BlockStateContainer func_180661_e() {
        if (this.variants == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{DEFAULT});
        }
        List<IProperty> list = this.getProperties();
        return new BlockStateContainer((Block)this, list.toArray(new IProperty[list.size()]));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.variants.get(0), (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)this.variants.get(0));
        return meta;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public Class getItemClass() {
        return ItemBlockMeta.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRender() {
        JointList names = new JointList();
        Item item = Item.func_150898_a((Block)this);
        if (this.sameIcon) {
            for (int meta = 0; meta < this.nSubBlocks; ++meta) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
            }
        } else {
            for (int meta = 0; meta < this.nSubBlocks; ++meta) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_" + meta, "inventory"));
            }
        }
    }
}

