/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.blocks.BlockContainerLC;
import sblectric.lightningcraft.blocks.IFurnace;
import sblectric.lightningcraft.items.blocks.ItemBlockRarity;
import sblectric.lightningcraft.main.LightningCraft;
import sblectric.lightningcraft.tiles.TileEntityLightningFurnace;

public class BlockLightningFurnace
extends BlockContainerLC
implements IFurnace {
    private static final PropertyDirection dir = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final PropertyBool lit = PropertyBool.func_177716_a((String)"active");
    private static boolean keepInventory = false;

    public BlockLightningFurnace() {
        super(Blocks.field_150460_al, 3.0f, 20.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)dir, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)lit, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{dir, lit});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityLightningFurnace();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack s, EnumFacing side, float hitX, float hitY, float hitZ) {
        player.openGui((Object)LightningCraft.modInstance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        int side = Math.max(2, meta % 6);
        boolean on = meta / 6 > 0;
        return this.func_176223_P().func_177226_a((IProperty)dir, (Comparable)EnumFacing.func_82600_a((int)side)).func_177226_a((IProperty)lit, (Comparable)Boolean.valueOf(on));
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing type = (EnumFacing)state.func_177229_b((IProperty)dir);
        return type.func_176745_a() + 6 * ((Boolean)state.func_177229_b((IProperty)lit) != false ? 1 : 0);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)dir, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)dir, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!keepInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean isBurning(IBlockState state, IBlockAccess world, BlockPos pos) {
        try {
            return (Boolean)state.func_177229_b((IProperty)lit);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public void setBurning(IBlockState state, IBlockAccess world, BlockPos pos, boolean burning) {
        TileEntity tile = world.func_175625_s(pos);
        keepInventory = true;
        ((World)world).func_175656_a(pos, state.func_177226_a((IProperty)lit, (Comparable)Boolean.valueOf(burning)));
        keepInventory = false;
        tile.func_145829_t();
        ((World)world).func_175690_a(pos, tile);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isBurning(state, world, pos) ? 12 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isBurning(state, (IBlockAccess)world, pos)) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)dir);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            switch (enumfacing) {
                case WEST: {
                    world.func_175688_a(EnumParticleTypes.REDSTONE, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    world.func_175688_a(EnumParticleTypes.REDSTONE, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    world.func_175688_a(EnumParticleTypes.REDSTONE, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    world.func_175688_a(EnumParticleTypes.REDSTONE, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
            }
        }
    }

    public Class getItemClass() {
        return ItemBlockRarity.class;
    }

    @Override
    public Object[] getItemClassArgs() {
        return new Object[]{EnumRarity.UNCOMMON};
    }
}

