/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.blocks;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import sblectric.lightningcraft.blocks.BlockMeta;
import sblectric.lightningcraft.items.blocks.ItemBlockMetal;
import sblectric.lightningcraft.ref.Metal;
import sblectric.lightningcraft.util.JointList;

public class BlockMetal
extends BlockMeta {
    protected IProperty type;

    public BlockMetal(float hardness, float resistance) {
        super(Blocks.field_150339_S, 3, hardness, resistance, false);
    }

    public BlockMetal() {
        this(6.5f, 40.0f);
    }

    @Override
    protected List<IProperty> getProperties() {
        Object[] objectArray = new Object[1];
        this.type = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
        objectArray[0] = this.type;
        return new JointList<Object>().join(objectArray);
    }

    @Override
    protected void setDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.type, (Comparable)((Object)EnumType.DEFAULT)));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.type, (Comparable)((Object)EnumType.getTypeFromMeta(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(this.type))).getID();
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return true;
    }

    @Override
    public Class getItemClass() {
        return ItemBlockMetal.class;
    }

    public static enum EnumType implements IStringSerializable
    {
        ELEC(0),
        SKY(1),
        MYSTIC(2);

        private static final EnumType DEFAULT;
        private int ID;
        private String name;

        private EnumType(int meta) {
            this.ID = meta;
            this.name = Metal.Ingot.getNameFromMeta(meta).toLowerCase();
        }

        public static EnumType getTypeFromMeta(int meta) {
            for (EnumType m : EnumType.values()) {
                if (m.ID != meta) continue;
                return m;
            }
            return DEFAULT;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public int getID() {
            return this.ID;
        }

        static {
            DEFAULT = ELEC;
        }
    }
}

