/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.events;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.blocks.PortalUnderworld;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.dimensions.LCDimensions;
import sblectric.lightningcraft.items.ItemBattery;
import sblectric.lightningcraft.items.LCItems;
import sblectric.lightningcraft.items.ifaces.IKineticGear;
import sblectric.lightningcraft.items.ifaces.IMysticGear;
import sblectric.lightningcraft.potions.LCPotions;
import sblectric.lightningcraft.ref.LCText;
import sblectric.lightningcraft.util.InventoryLE;
import sblectric.lightningcraft.util.JointList;
import sblectric.lightningcraft.util.SkyUtils;

public class PlayerEvents {
    public static final int repairTime = 100;
    static final float walkBoostSky = 0.35123f;
    static final float walkBoostMystic = 0.55123f;
    static final float stepBoost = 1.01789f;
    static final UUID speedBootsID = UUID.fromString("caac9ed0-a4a7-42c1-af76-0482f06f34d8");

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntity();
            if (!player.field_70170_p.field_72995_K) {
                EntityPlayerMP mp = (EntityPlayerMP)player;
                this.handleRepair((EntityPlayer)mp);
                this.handleServerPotionEffects((EntityPlayer)mp);
                this.handleTeleportation(mp);
            }
            this.onStepBootsWear(player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerRenderTick(TickEvent.RenderTickEvent e) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        this.handleClientPotionEffects((EntityPlayer)player);
    }

    private void handleClientPotionEffects(EntityPlayer player) {
        if (player.field_71093_bK == LCDimensions.underworldID && player.func_70644_a(MobEffects.field_76439_r)) {
            player.func_184596_c(MobEffects.field_76439_r);
        }
    }

    private void handleServerPotionEffects(EntityPlayer player) {
        if (player.field_71093_bK == LCDimensions.underworldID && player.func_70644_a(MobEffects.field_76439_r)) {
            player.func_184589_d(MobEffects.field_76439_r);
        }
        if (player.func_70644_a(LCPotions.demonFriend) && player.func_70660_b(LCPotions.demonFriend).func_76459_b() == 0) {
            player.func_184589_d(LCPotions.demonFriend);
        }
    }

    private void handleTeleportation(EntityPlayerMP mp) {
        if (PortalUnderworld.portalStatus.checkCooldown(mp) && PortalUnderworld.portalStatus.getPortal(mp)) {
            PortalUnderworld.doTeleport(mp);
            PortalUnderworld.portalStatus.resetCooldown(mp);
        } else {
            PortalUnderworld.portalStatus.setPortal(mp, false);
        }
    }

    private void onStepBootsWear(EntityPlayer player) {
        boolean isMystic = false;
        IAttributeInstance attributeinstance = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        AttributeModifier mod = new AttributeModifier(speedBootsID, "skyBootsSpeedModifier", (double)0.35123f, 2).func_111168_a(false);
        AttributeModifier mystic = new AttributeModifier(speedBootsID, "mysticBootsSpeedModifier", (double)0.55123f, 2).func_111168_a(false);
        if (player.func_184582_a(EntityEquipmentSlot.FEET) != null) {
            if (player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() != LCItems.skyBoots) {
                if (player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == LCItems.mysticBoots) {
                    isMystic = true;
                    mod = mystic;
                } else {
                    this.removeAttributes(player, attributeinstance, mod);
                    mod = null;
                }
            }
            if (mod != null) {
                if (attributeinstance.func_111127_a(speedBootsID) == null) {
                    attributeinstance.func_111121_a(mod);
                }
                player.field_70138_W = !player.func_70093_af() ? 1.01789f * (isMystic ? 2.0f : 1.0f) : 0.5f;
            }
        } else {
            this.removeAttributes(player, attributeinstance, mod);
        }
    }

    private void removeAttributes(EntityPlayer player, IAttributeInstance instance, AttributeModifier mod) {
        if (instance.func_111127_a(speedBootsID) != null) {
            instance.func_111124_b(mod);
        }
        if (player.field_70138_W == 1.01789f || player.field_70138_W == 2.03578f) {
            player.field_70138_W = 0.5f;
        }
    }

    private void handleRepair(EntityPlayer player) {
        JointList<ItemStack> inv = new JointList<ItemStack>().join(player.field_71071_by.field_70462_a).join((ItemStack[])player.field_71071_by.field_70460_b);
        for (ItemStack stack : inv) {
            if (stack == null) continue;
            if (LCConfig.autoRepair && stack.func_77973_b() instanceof IMysticGear) {
                this.doAutoRepair(player, stack, 1.0);
                continue;
            }
            if (!(stack.func_77973_b() instanceof IKineticGear)) continue;
            this.doKineticRepair(player, stack, 2.25);
        }
    }

    private boolean doAutoRepair(EntityPlayer player, ItemStack stack, double speed) {
        if (SkyUtils.canWriteItemNBT(stack, player)) {
            int damage = stack.func_77952_i();
            if (damage > 0) {
                if (player.field_70173_aa % MathHelper.func_76128_c((double)(100.0 / speed)) == 0) {
                    stack.func_77964_b(damage - 1);
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    private boolean doKineticRepair(EntityPlayer player, ItemStack stack, double speed) {
        ItemStack battery = InventoryLE.getLESource(player, 0.02);
        if (battery != null && this.doAutoRepair(player, stack, speed)) {
            ItemBattery.addStoredPower(battery, -0.02);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onTooltipShow(ItemTooltipEvent e) {
        if (e.getItemStack() != null) {
            this.showAutoRepairTooltip(e.getItemStack(), e.getToolTip());
        }
    }

    private void showAutoRepairTooltip(ItemStack stack, List list) {
        if (stack.func_77973_b() instanceof IMysticGear) {
            list.add(1, LCText.getAutoRepairLore());
        }
    }
}

