/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.integration.jei.infusion;

import java.util.Collection;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import sblectric.lightningcraft.integration.jei.infusion.LightningInfusionRecipeWrapper;

public class LightningInfusionRecipeCategory
extends BlankRecipeCategory {
    public static final String UID = "lightningcraft.infusionRecipeCategory";
    public static final String NAME = I18n.func_74838_a((String)"lightningcraft.infusionRecipeCategory");
    private static final int INFUSE = 0;
    private static final int[] SURROUND = new int[]{1, 2, 3, 4};
    private static final int OUTPUT = 5;
    public static final ResourceLocation location = new ResourceLocation("lightningcraft", "textures/gui/container/lpinfuser.png");
    private IDrawable background;
    private IDrawableAnimated arrow;

    public LightningInfusionRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(location, 8, 20, 128, 60, 0, 0, 0, 0);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, 176, 14, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 600, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return NAME;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawAnimations(Minecraft minecraft) {
        this.arrow.draw(minecraft, 68, 20);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, true, 25, 20);
        stacks.init(SURROUND[0], true, 25, 0);
        stacks.init(SURROUND[1], true, 45, 20);
        stacks.init(SURROUND[2], true, 25, 40);
        stacks.init(SURROUND[3], true, 5, 20);
        stacks.init(5, false, 102, 15);
        if (recipeWrapper instanceof LightningInfusionRecipeWrapper) {
            LightningInfusionRecipeWrapper lirWrapper = (LightningInfusionRecipeWrapper)recipeWrapper;
            stacks.set(0, lirWrapper.getInfuseItem());
            for (int i = 0; i < SURROUND.length; ++i) {
                stacks.set(SURROUND[i], (Collection)lirWrapper.getSurroundingItems().get(i));
            }
            stacks.set(5, (ItemStack)recipeWrapper.getOutputs().get(0));
        }
    }
}

