/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.proxy;

import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import sblectric.lightningcraft.achievements.LCAchievements;
import sblectric.lightningcraft.biomes.LCBiomes;
import sblectric.lightningcraft.blocks.LCBlocks;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.crafting.LCCraftingManager;
import sblectric.lightningcraft.creativetabs.LCCreativeTabs;
import sblectric.lightningcraft.dimensions.LCDimensions;
import sblectric.lightningcraft.enchantments.LCEnchantments;
import sblectric.lightningcraft.entities.LCEntities;
import sblectric.lightningcraft.events.LCEvents;
import sblectric.lightningcraft.gui.LCGuiHandler;
import sblectric.lightningcraft.integration.LCModIntegration;
import sblectric.lightningcraft.items.LCItems;
import sblectric.lightningcraft.main.LightningCraft;
import sblectric.lightningcraft.network.LCNetwork;
import sblectric.lightningcraft.potions.LCPotions;
import sblectric.lightningcraft.ref.LCText;
import sblectric.lightningcraft.ref.Log;
import sblectric.lightningcraft.sounds.LCSoundEvents;
import sblectric.lightningcraft.tiles.LCTileEntities;
import sblectric.lightningcraft.worldgen.structure.LCStructures;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        Log.logger.info("PreInitializing LightningCraft...");
        LCText.setupFormatting();
        LCConfig.loadConfig(event.getSuggestedConfigurationFile());
        LCCreativeTabs.mainRegistry();
        LCBlocks.mainRegistry();
        LCItems.mainRegistry();
        LCTileEntities.registerTileEntities();
        LCEntities.mainRegistry();
        LCPotions.mainRegistry();
        LCBiomes.mainRegistry();
        LCEnchantments.mainRegistry();
        LCSoundEvents.mainRegistry();
        LCNetwork.mainRegistry();
        LCModIntegration.preInit();
    }

    public void onInit(FMLInitializationEvent event) {
        Log.logger.info("Initializing LightningCraft...");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)LightningCraft.modInstance, (IGuiHandler)new LCGuiHandler());
        LCDimensions.mainRegistry();
        LCStructures.mainRegistry();
        LCAchievements.mainRegistry();
        LCEvents.mainRegistry();
        LCCraftingManager.mainRegistry();
        LCCreativeTabs.updateCreativeTabs();
        LCModIntegration.onInit();
    }

    public void postInit(FMLPostInitializationEvent event) {
        Log.logger.info("PostInitializing LightningCraft...");
        LCModIntegration.postInit();
    }
}

