/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.registry;

import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Constructor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.ref.Log;
import sblectric.lightningcraft.registry.IRegistryBlock;
import sblectric.lightningcraft.registry.IRegistryItem;

public class RegistryHelper {
    public static void registerBlocks(Iterable<IRegistryBlock> regBlocks) {
        for (IRegistryBlock r : regBlocks) {
            RegistryHelper.registerBlock(r);
        }
    }

    public static void registerItems(Iterable<IRegistryItem> regItems) {
        for (IRegistryItem r : regItems) {
            r.setRarity();
            RegistryHelper.registerItem(r);
        }
    }

    public static void registerBlock(IRegistryBlock regBlock) {
        Block block = (Block)regBlock;
        GameRegistry.register((IForgeRegistryEntry)block.func_149663_c(block.getRegistryName().func_110623_a()));
        if (regBlock.getItemClass() != null) {
            ItemBlock item;
            try {
                Class[] ctorArgClasses = new Class[regBlock.getItemClassArgs().length + 1];
                ctorArgClasses[0] = Block.class;
                for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                    ctorArgClasses[idx] = regBlock.getItemClassArgs()[idx - 1].getClass();
                }
                Constructor<? extends ItemBlock> itemCtor = regBlock.getItemClass().getConstructor(ctorArgClasses);
                item = itemCtor.newInstance(ObjectArrays.concat((Object)regBlock, (Object[])regBlock.getItemClassArgs()));
            }
            catch (Exception e) {
                Log.logger.error("Unable to register block " + block.getRegistryName());
                return;
            }
            GameRegistry.register((IForgeRegistryEntry)item.setRegistryName(block.getRegistryName()));
        }
    }

    public static void registerItem(IRegistryItem regItem) {
        Item item = (Item)regItem;
        GameRegistry.register((IForgeRegistryEntry)item.func_77655_b(item.getRegistryName().func_110623_a()));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerEntityRenderer(Class<? extends Entity> entityClass, Render<? extends Entity> renderer) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, renderer);
    }
}

