/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.tiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.blocks.IFurnace;
import sblectric.lightningcraft.blocks.LCBlocks;
import sblectric.lightningcraft.tiles.TileEntityLightningItemHandler;

public class TileEntityLightningFurnace
extends TileEntityLightningItemHandler {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{1};
    private static final int[] slotsSides = new int[]{0};
    private static final int burnTime = 80;
    private ItemStack[] furnaceItemStacks = new ItemStack[2];
    public int furnaceBurnTime;
    public int furnaceCookTime;
    public int currentBurnTime;
    private String furnaceName;

    public void furnaceName(String string) {
        this.furnaceName = string;
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.furnaceItemStacks[slot];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.furnaceItemStacks[par1] != null) {
            if (this.furnaceItemStacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.furnaceItemStacks[par1];
                this.furnaceItemStacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.furnaceItemStacks[par1].func_77979_a(par2);
            if (this.furnaceItemStacks[par1].field_77994_a == 0) {
                this.furnaceItemStacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.furnaceItemStacks[slot] != null) {
            ItemStack itemstack = this.furnaceItemStacks[slot];
            this.furnaceItemStacks[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.furnaceItemStacks[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.furnaceName : LCBlocks.lightningFurnace.func_149732_F();
    }

    public boolean func_145818_k_() {
        return this.furnaceName != null && this.furnaceName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / 40;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentBurnTime == 0) {
            this.currentBurnTime = 40;
        }
        return this.furnaceBurnTime * par1 / this.currentBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_73660_a() {
        boolean burning = this.furnaceBurnTime > 0;
        boolean dosave = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.furnaceBurnTime = 80;
                this.currentBurnTime = 80;
                if (this.furnaceBurnTime > 0) {
                    dosave = true;
                    this.drawCellPower(1.0);
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == 40) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    dosave = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (burning != this.furnaceBurnTime > 0) {
                dosave = true;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                ((IFurnace)state.func_177230_c()).setBurning(state, (IBlockAccess)this.field_145850_b, this.field_174879_c, this.furnaceBurnTime > 0);
            }
        }
        if (dosave) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (!this.hasLPCell() || !this.canDrawCellPower(1.0)) {
            return false;
        }
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.furnaceItemStacks[1] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[1].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.furnaceItemStacks[1].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.furnaceItemStacks[1].func_77976_d();
    }

    private void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
            if (this.furnaceItemStacks[1] == null) {
                this.furnaceItemStacks[1] = itemstack.func_77946_l();
            } else if (this.furnaceItemStacks[1].func_77973_b() == itemstack.func_77973_b()) {
                this.furnaceItemStacks[1].field_77994_a += itemstack.field_77994_a;
            }
            --this.furnaceItemStacks[0].field_77994_a;
            if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                this.furnaceItemStacks[0] = null;
            }
        }
    }

    public boolean func_94041_b(int par1, ItemStack itemstack) {
        return par1 != 1;
    }

    public int[] func_180463_a(EnumFacing facing) {
        int par1 = facing.func_176745_a();
        return par1 == 0 ? slotsBottom : (par1 == 1 ? slotsSides : slotsTop);
    }

    public boolean func_180462_a(int par1, ItemStack itemstack, EnumFacing facing) {
        return this.func_94041_b(par1, itemstack);
    }

    public boolean func_180461_b(int par1, ItemStack itemstack, EnumFacing facing) {
        return facing.func_176745_a() != 0 || par1 == 1 || itemstack.func_77973_b() == Items.field_151133_ar;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tabCompound1 = tagList.func_150305_b(i);
            byte byte0 = tabCompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)tabCompound1);
        }
        this.furnaceBurnTime = tagCompound.func_74765_d("BurnTime");
        this.furnaceCookTime = tagCompound.func_74765_d("CookTime");
        this.currentBurnTime = 80;
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.furnaceName = tagCompound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.furnaceBurnTime);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound tagCompound1 = new NBTTagCompound();
            tagCompound1.func_74774_a("Slot", (byte)i);
            this.furnaceItemStacks[i].func_77955_b(tagCompound1);
            tagList.func_74742_a((NBTBase)tagCompound1);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        if (this.func_145818_k_()) {
            tagCompound.func_74778_a("CustomName", this.furnaceName);
        }
        return tagCompound;
    }
}

