/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.api.registry.ILightningCraftBlock;
import sblectric.lightningcraft.api.util.JointList;
import sblectric.lightningcraft.entities.EntityLCTNTPrimed;
import sblectric.lightningcraft.init.LCItems;
import sblectric.lightningcraft.items.blocks.ItemBlockUnderTNT;

public class BlockUnderTNT
extends BlockTNT
implements ILightningCraftBlock {
    public static final int nVariants = 3;
    public static final int RAMPART = 0;
    public static final int LIGHTNING = 1;
    public static final int MYSTIC = 2;
    private static final PropertyInteger VARIANT = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)2);

    public BlockUnderTNT() {
        this.func_149672_a(SoundType.field_185855_h);
        this.func_149711_c(10.0f);
        this.func_149752_b(5.0f);
    }

    public void func_149666_a(Item item, CreativeTabs tab, NonNullList list) {
        for (int i = 0; i < 3; ++i) {
            list.add((Object)new ItemStack(item, 1, i));
        }
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.func_185473_a(world, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176246_a, VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(meta % 8)).func_177226_a((IProperty)field_176246_a, (Comparable)Boolean.valueOf(meta / 8 > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VARIANT) + ((Boolean)state.func_177229_b((IProperty)field_176246_a) != false ? 8 : 0);
    }

    public void func_180692_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase igniter) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)field_176246_a)).booleanValue()) {
            EntityLCTNTPrimed entitytntprimed = new EntityLCTNTPrimed(worldIn, (Integer)state.func_177229_b((IProperty)VARIANT), (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, igniter);
            worldIn.func_72838_d((Entity)entitytntprimed);
            worldIn.func_184148_a(null, entitytntprimed.field_70165_t, entitytntprimed.field_70163_u, entitytntprimed.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void onBlockExploded(World worldIn, BlockPos pos, Explosion explosionIn) {
        int variant = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)VARIANT);
        worldIn.func_175698_g(pos);
        if (!worldIn.field_72995_K) {
            EntityLCTNTPrimed entitytntprimed = new EntityLCTNTPrimed(worldIn, variant, (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, explosionIn.func_94613_c());
            entitytntprimed.fuse = worldIn.field_73012_v.nextInt(entitytntprimed.fuse / 4) + entitytntprimed.fuse / 8;
            worldIn.func_72838_d((Entity)entitytntprimed);
        }
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        switch ((Integer)state.func_177229_b((IProperty)VARIANT)) {
            case 0: {
                return LCItems.material;
            }
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        switch ((Integer)state.func_177229_b((IProperty)VARIANT)) {
            case 0: {
                return 13;
            }
        }
        return this.func_176201_c(state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random rand) {
        switch ((Integer)state.func_177229_b((IProperty)VARIANT)) {
            case 0: {
                return rand.nextInt(3) + 1;
            }
        }
        return 1;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public Class getItemClass() {
        return ItemBlockUnderTNT.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRender() {
        JointList names = new JointList();
        Item item = Item.func_150898_a((Block)this);
        for (int meta = 0; meta < 3; ++meta) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_" + meta, "inventory"));
        }
    }
}

