/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.integration.jei.infusion;

import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sblectric.lightningcraft.api.recipes.LightningInfusionRecipe;
import sblectric.lightningcraft.api.util.JointList;
import sblectric.lightningcraft.api.util.StackHelper;

public class LightningInfusionRecipeWrapper
extends BlankRecipeWrapper {
    private final LightningInfusionRecipe recipe;

    public LightningInfusionRecipeWrapper(LightningInfusionRecipe recipe) {
        this.recipe = recipe;
    }

    public List getInputs() {
        return new JointList<List>().join(new List[]{this.getInfuseItem()}).join((Iterable<List>)this.getSurroundingItems());
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String need = this.recipe.getCost() + " LE needed";
        minecraft.field_71466_p.func_78276_b(need, 100 - minecraft.field_71466_p.func_78256_a(need) / 2, 48, 0x404040);
    }

    public List<ItemStack> getInfuseItem() {
        JointList<ItemStack> result = new JointList<ItemStack>();
        String infuse = this.recipe.getInfuseItem();
        if (OreDictionary.doesOreNameExist((String)infuse)) {
            result.join((Iterable<ItemStack>)OreDictionary.getOres((String)infuse));
        } else {
            result.join((ItemStack[])new ItemStack[]{StackHelper.makeItemStackFromString(infuse)});
        }
        return result;
    }

    public List<List<ItemStack>> getSurroundingItems() {
        JointList<List<ItemStack>> result = new JointList<List<ItemStack>>();
        List<String> surround = this.recipe.getItems();
        for (String item : surround) {
            JointList<ItemStack> current = new JointList<ItemStack>();
            if (OreDictionary.doesOreNameExist((String)item)) {
                current.join((Iterable<ItemStack>)OreDictionary.getOres((String)item));
            } else {
                current.join(StackHelper.makeItemStackFromString(item));
            }
            result.add(current);
        }
        return result;
    }

    public List getOutputs() {
        return new JointList<Object>().join(this.recipe.getOutput());
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.getInputs());
        ingredients.setOutputs(ItemStack.class, this.getOutputs());
    }
}

