/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.registry;

import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Constructor;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import sblectric.lightningcraft.api.registry.ILightningCraftBlock;
import sblectric.lightningcraft.api.registry.ILightningCraftItem;
import sblectric.lightningcraft.ref.Log;

public class RegistryHelper {
    public static void registerBlocks(Iterable<ILightningCraftBlock> regBlocks) {
        for (ILightningCraftBlock r : regBlocks) {
            RegistryHelper.registerBlock(r);
        }
    }

    public static void registerItems(Iterable<ILightningCraftItem> regItems) {
        for (ILightningCraftItem r : regItems) {
            r.setRarity();
            RegistryHelper.registerItem(r);
        }
    }

    public static void registerBlock(ILightningCraftBlock regBlock) {
        Block block = (Block)regBlock;
        GameRegistry.register((IForgeRegistryEntry)block.func_149663_c(block.getRegistryName().toString()));
        if (regBlock.getItemClass() != null) {
            ItemBlock item;
            try {
                Class[] ctorArgClasses = new Class[regBlock.getItemClassArgs().length + 1];
                ctorArgClasses[0] = Block.class;
                for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                    ctorArgClasses[idx] = regBlock.getItemClassArgs()[idx - 1].getClass();
                }
                Constructor<? extends ItemBlock> itemCtor = regBlock.getItemClass().getConstructor(ctorArgClasses);
                item = itemCtor.newInstance(ObjectArrays.concat((Object)regBlock, (Object[])regBlock.getItemClassArgs()));
            }
            catch (Exception e) {
                Log.logger.error("Unable to register block " + block.getRegistryName());
                return;
            }
            GameRegistry.register((IForgeRegistryEntry)item.setRegistryName(block.getRegistryName()));
        }
    }

    public static void registerItem(ILightningCraftItem regItem) {
        Item item = (Item)regItem;
        GameRegistry.register((IForgeRegistryEntry)item.func_77655_b(item.getRegistryName().toString()));
    }
}

